/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.segment.BindingTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBindingTableRulesStatement;

public final class DropShardingBindingTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingBindingTableRulesStatement, ShardingRuleConfiguration> {
    private Map<String, String> bindingTableRules = Collections.emptyMap();

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isContainsExistClause()) {
            return;
        }
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.bindingTableRules = this.buildBindingTableRule(currentRuleConfig);
        this.checkBindingTableRuleExist(schemaName, sqlStatement, this.bindingTableRules);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig && !currentRuleConfig.getBindingTableGroups().isEmpty() ? 1 : 0) != 0, () -> new RequiredRuleMissedException("Binding", schemaName));
    }

    private Map<String, String> buildBindingTableRule(ShardingRuleConfiguration configuration) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        configuration.getBindingTableGroups().forEach(each -> Arrays.stream(each.split(",")).forEach(each1 -> result.put((String)each1, (String)each)));
        return result;
    }

    private void checkBindingTableRuleExist(String schemaName, DropShardingBindingTableRulesStatement sqlStatement, Map<String, String> bindingRelationship) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        LinkedList<String> notExistBindingGroups = new LinkedList<String>();
        for (BindingTableRuleSegment each : sqlStatement.getRules()) {
            if (this.isToBeDroppedRuleExists(each, bindingRelationship)) continue;
            notExistBindingGroups.add(each.getTableGroups());
        }
        DistSQLException.predictionThrow((boolean)notExistBindingGroups.isEmpty(), () -> new RequiredRuleMissedException("Binding", schemaName, notExistBindingGroups));
    }

    private boolean isToBeDroppedRuleExists(BindingTableRuleSegment bindingRule, Map<String, String> bindingRelationship) {
        String currentBindingRule;
        Optional anyTableInToBeAlteredRule = bindingRule.getBindingTables().stream().findAny();
        if (anyTableInToBeAlteredRule.isPresent() && !Strings.isNullOrEmpty((String)(currentBindingRule = bindingRelationship.get(anyTableInToBeAlteredRule.get())))) {
            List currentBindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)currentBindingRule);
            return bindingRule.getBindingTables().containsAll(currentBindingTables);
        }
        return false;
    }

    public boolean hasAnyOneToBeDropped(DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig)) {
            return false;
        }
        if (this.bindingTableRules.isEmpty()) {
            this.bindingTableRules = this.buildBindingTableRule(currentRuleConfig);
        }
        return !this.getExistedBindingGroups(sqlStatement, this.bindingTableRules).isEmpty();
    }

    private Collection<String> getExistedBindingGroups(DropShardingBindingTableRulesStatement sqlStatement, Map<String, String> bindingTableRules) {
        LinkedList<String> result = new LinkedList<String>();
        if (sqlStatement.getRules().isEmpty()) {
            return new LinkedHashSet<String>(bindingTableRules.values());
        }
        for (BindingTableRuleSegment each : sqlStatement.getRules()) {
            if (!this.isToBeDroppedRuleExists(each, bindingTableRules)) continue;
            result.add(each.getTableGroups());
        }
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingBindingTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getBindingTableGroups().clear();
        if (!sqlStatement.getRules().isEmpty()) {
            sqlStatement.getRules().forEach(each -> each.getBindingTables().forEach(each1 -> this.bindingTableRules.remove(each1)));
            currentRuleConfig.getBindingTableGroups().addAll(new LinkedHashSet<String>(this.bindingTableRules.values()));
        }
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingBindingTableRulesStatement.class.getName();
    }
}

