/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.converter;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.KeyGenerateStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.TableRuleSegment;

public final class ShardingTableRuleStatementConverter {
    public static ShardingRuleConfiguration convert(Collection<AbstractTableRuleSegment> rules) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        rules.forEach(each -> {
            result.getKeyGenerators().putAll(ShardingTableRuleStatementConverter.createKeyGeneratorConfiguration(each));
            if (each instanceof AutoTableRuleSegment) {
                result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((AutoTableRuleSegment)each));
                result.getAutoTables().add(ShardingTableRuleStatementConverter.createAutoTableRuleConfiguration((AutoTableRuleSegment)each));
            }
            if (each instanceof TableRuleSegment) {
                result.getShardingAlgorithms().putAll(ShardingTableRuleStatementConverter.createAlgorithmConfiguration((TableRuleSegment)each));
                result.getTables().add(ShardingTableRuleStatementConverter.createTableRuleConfiguration((TableRuleSegment)each));
            }
        });
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createKeyGeneratorConfiguration(AbstractTableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        Optional.ofNullable(rule.getKeyGenerateStrategySegment()).ifPresent(op -> {
            if (!op.getKeyGenerateAlgorithmName().isPresent()) {
                result.put(ShardingTableRuleStatementConverter.getKeyGeneratorName(rule.getLogicTable(), op.getKeyGenerateAlgorithmSegment().getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(op.getKeyGenerateAlgorithmSegment()));
            }
        });
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createAlgorithmConfiguration(AutoTableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        Optional.ofNullable(rule.getShardingAlgorithmSegment()).ifPresent(op -> result.put(ShardingTableRuleStatementConverter.getAutoTableShardingAlgorithmName(rule.getLogicTable(), op.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(op)));
        return result;
    }

    private static Map<String, ShardingSphereAlgorithmConfiguration> createAlgorithmConfiguration(TableRuleSegment rule) {
        HashMap<String, ShardingSphereAlgorithmConfiguration> result = new HashMap<String, ShardingSphereAlgorithmConfiguration>();
        if (null != rule.getTableStrategySegment()) {
            Optional.ofNullable(rule.getTableStrategySegment().getAlgorithmSegment()).ifPresent(op -> result.put(ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(rule.getLogicTable(), ShardingStrategyLevelType.TABLE, op.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(op)));
        }
        if (null != rule.getDatabaseStrategySegment()) {
            Optional.ofNullable(rule.getDatabaseStrategySegment().getAlgorithmSegment()).ifPresent(op -> result.put(ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(rule.getLogicTable(), ShardingStrategyLevelType.DATABASE, op.getName()), ShardingTableRuleStatementConverter.createAlgorithmConfiguration(op)));
        }
        return result;
    }

    public static ShardingSphereAlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new ShardingSphereAlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private static ShardingAutoTableRuleConfiguration createAutoTableRuleConfiguration(AutoTableRuleSegment rule) {
        ShardingAutoTableRuleConfiguration result = new ShardingAutoTableRuleConfiguration(rule.getLogicTable(), Joiner.on((String)",").join((Iterable)rule.getDataSourceNodes()));
        result.setShardingStrategy(ShardingTableRuleStatementConverter.createAutoTableStrategyConfiguration(rule));
        Optional.ofNullable(rule.getKeyGenerateStrategySegment()).ifPresent(op -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(rule.getLogicTable(), rule.getKeyGenerateStrategySegment())));
        return result;
    }

    private static ShardingStrategyConfiguration createAutoTableStrategyConfiguration(AutoTableRuleSegment rule) {
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.STANDARD.name(), rule.getShardingColumn(), ShardingTableRuleStatementConverter.getAutoTableShardingAlgorithmName(rule.getLogicTable(), rule.getShardingAlgorithmSegment().getName()));
    }

    private static ShardingTableRuleConfiguration createTableRuleConfiguration(TableRuleSegment tableRuleSegment) {
        String dataSourceNodes = String.join((CharSequence)",", tableRuleSegment.getDataSourceNodes());
        ShardingTableRuleConfiguration result = new ShardingTableRuleConfiguration(tableRuleSegment.getLogicTable(), dataSourceNodes);
        Optional.ofNullable(tableRuleSegment.getTableStrategySegment()).ifPresent(op -> result.setTableShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(tableRuleSegment.getLogicTable(), ShardingStrategyLevelType.TABLE, op.getType(), op)));
        Optional.ofNullable(tableRuleSegment.getDatabaseStrategySegment()).ifPresent(op -> result.setDatabaseShardingStrategy(ShardingTableRuleStatementConverter.createShardingStrategyConfiguration(tableRuleSegment.getLogicTable(), ShardingStrategyLevelType.DATABASE, op.getType(), op)));
        Optional.ofNullable(tableRuleSegment.getKeyGenerateStrategySegment()).ifPresent(op -> result.setKeyGenerateStrategy(ShardingTableRuleStatementConverter.createKeyGenerateStrategyConfiguration(tableRuleSegment.getLogicTable(), op)));
        return result;
    }

    private static ShardingStrategyConfiguration createShardingStrategyConfiguration(String logicTable, ShardingStrategyLevelType strategyLevel, String type, ShardingStrategySegment segment) {
        String shardingAlgorithmName = null == segment.getShardingAlgorithmName() ? ShardingTableRuleStatementConverter.getTableShardingAlgorithmName(logicTable, strategyLevel, segment.getAlgorithmSegment().getName()) : segment.getShardingAlgorithmName();
        return ShardingTableRuleStatementConverter.createStrategyConfiguration(ShardingStrategyType.getValueOf(type).name(), segment.getShardingColumn(), shardingAlgorithmName);
    }

    private static KeyGenerateStrategyConfiguration createKeyGenerateStrategyConfiguration(String logicTable, KeyGenerateStrategySegment segment) {
        if (segment.getKeyGenerateAlgorithmName().isPresent()) {
            return new KeyGenerateStrategyConfiguration(segment.getKeyGenerateColumn(), (String)segment.getKeyGenerateAlgorithmName().get());
        }
        return new KeyGenerateStrategyConfiguration(segment.getKeyGenerateColumn(), ShardingTableRuleStatementConverter.getKeyGeneratorName(logicTable, segment.getKeyGenerateAlgorithmSegment().getName()));
    }

    public static ShardingStrategyConfiguration createStrategyConfiguration(String strategyType, String shardingColumn, String shardingAlgorithmName) {
        ShardingStrategyType shardingStrategyType = ShardingStrategyType.getValueOf(strategyType);
        return shardingStrategyType.createConfiguration(shardingAlgorithmName, shardingColumn);
    }

    private static String getAutoTableShardingAlgorithmName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName, algorithmType);
    }

    private static String getTableShardingAlgorithmName(String tableName, ShardingStrategyLevelType strategyLevel, String algorithmType) {
        return String.format("%s_%s_%s", tableName, strategyLevel.name().toLowerCase(), algorithmType);
    }

    private static String getKeyGeneratorName(String tableName, String columnName) {
        return String.format("%s_%s", tableName, columnName);
    }

    @Generated
    private ShardingTableRuleStatementConverter() {
    }
}

