/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.supporter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;

public final class ShadowRuleStatementSupporter {
    public static List<String> getRuleNames(ShadowRuleConfiguration configuration) {
        if (null == configuration) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(configuration.getDataSources().keySet());
    }

    public static List<String> getRuleNames(Collection<ShadowRuleSegment> rules) {
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        return rules.stream().map(ShadowRuleSegment::getRuleName).collect(Collectors.toList());
    }

    public static List<String> getTableNames(ShadowRuleConfiguration configuration) {
        if (null == configuration) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(configuration.getTables().keySet());
    }

    public static List<String> getTableNames(Collection<ShadowRuleSegment> rules) {
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        return rules.stream().flatMap(each -> each.getShadowTableRules().keySet().stream()).collect(Collectors.toList());
    }

    public static List<String> getResourceNames(Collection<ShadowRuleSegment> rules) {
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        return rules.stream().map(each -> Arrays.asList(each.getSource(), each.getShadow())).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> getAlgorithmNames(ShadowRuleConfiguration configuration) {
        if (null == configuration) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(configuration.getShadowAlgorithms().keySet());
    }

    public static List<String> getAlgorithmNames(Collection<ShadowRuleSegment> rules) {
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        return rules.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).map(ShadowAlgorithmSegment::getAlgorithmName).collect(Collectors.toList());
    }

    public static List<ShadowAlgorithmSegment> getShadowAlgorithmSegment(Collection<ShadowRuleSegment> rules) {
        return rules.stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ShadowTableConfiguration mergeConfiguration(ShadowTableConfiguration existingConfiguration, ShadowTableConfiguration newConfiguration) {
        existingConfiguration.getDataSourceNames().addAll(newConfiguration.getDataSourceNames());
        existingConfiguration.getShadowAlgorithmNames().addAll(newConfiguration.getShadowAlgorithmNames());
        return existingConfiguration;
    }
}

