/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmPostProcessor;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.env.Environment;

public abstract class AbstractAlgorithmProvidedBeanRegistry<T extends ShardingSphereAlgorithm>
implements BeanDefinitionRegistryPostProcessor,
BeanPostProcessor {
    private static final String POINT = ".";
    private static final String PROPS = "props";
    private static final String PROPS_SUFFIX = ".props";
    private static final String TYPE_SUFFIX = ".type";
    private final Environment environment;

    protected final void registerBean(String prefix, Class<T> algorithmClass, BeanDefinitionRegistry registry) {
        boolean existPrefix = PropertyUtil.containPropertyPrefix(this.environment, prefix);
        if (existPrefix) {
            Map paramMap = PropertyUtil.handle(this.environment, prefix, Map.class);
            Set<String> keys = paramMap.keySet().stream().map(key -> key.contains(POINT) ? key.substring(0, key.indexOf(POINT)) : key).collect(Collectors.toSet());
            LinkedHashMap<String, YamlShardingSphereAlgorithmConfiguration> shardingAlgorithmMap = new LinkedHashMap<String, YamlShardingSphereAlgorithmConfiguration>();
            keys.forEach(each -> {
                YamlShardingSphereAlgorithmConfiguration config = new YamlShardingSphereAlgorithmConfiguration();
                String propsPrefix = String.join((CharSequence)"", prefix, each, PROPS_SUFFIX);
                boolean existProps = PropertyUtil.containPropertyPrefix(this.environment, propsPrefix);
                if (existProps) {
                    Map propsMap = PropertyUtil.handle(this.environment, propsPrefix, Map.class);
                    config.getProps().putAll((Map<?, ?>)propsMap);
                }
                String typePrefix = String.join((CharSequence)"", prefix, each, TYPE_SUFFIX);
                String algorithmType = this.environment.getProperty(typePrefix);
                config.setType(algorithmType);
                shardingAlgorithmMap.put((String)each, config);
            });
            ShardingSphereServiceLoader.register(algorithmClass);
            shardingAlgorithmMap.forEach((key, algorithmConfiguration) -> {
                ShardingSphereAlgorithm algorithm = (ShardingSphereAlgorithm)TypedSPIRegistry.getRegisteredService((Class)algorithmClass, (String)algorithmConfiguration.getType(), (Properties)algorithmConfiguration.getProps());
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(algorithm.getClass());
                builder.addPropertyValue(PROPS, (Object)algorithmConfiguration.getProps());
                registry.registerBeanDefinition(key, (BeanDefinition)builder.getBeanDefinition());
            });
        }
    }

    public final void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof ShardingSphereAlgorithmPostProcessor) {
            ((ShardingSphereAlgorithmPostProcessor)bean).init();
        }
        return bean;
    }

    @Generated
    protected AbstractAlgorithmProvidedBeanRegistry(Environment environment) {
        this.environment = environment;
    }
}

