/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerators;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.builder.DefaultTokenGeneratorBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;

public final class SQLRewriteContext {
    private final String schemaName;
    private final ShardingSphereSchema schema;
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final ParameterBuilder parameterBuilder;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();

    public SQLRewriteContext(String schemaName, ShardingSphereSchema schema, SQLStatementContext<?> sqlStatementContext, String sql, List<Object> parameters) {
        this.schemaName = schemaName;
        this.schema = schema;
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = parameters;
        this.addSQLTokenGenerators(new DefaultTokenGeneratorBuilder(sqlStatementContext).getSQLTokenGenerators());
        this.parameterBuilder = sqlStatementContext instanceof InsertStatementContext && null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext() ? new GroupedParameterBuilder(((InsertStatementContext)sqlStatementContext).getGroupedParameters(), ((InsertStatementContext)sqlStatementContext).getOnDuplicateKeyUpdateParameters()) : new StandardParameterBuilder(parameters);
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.sqlStatementContext, this.parameters, this.schema));
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public ShardingSphereSchema getSchema() {
        return this.schema;
    }

    @Generated
    public SQLStatementContext<?> getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }

    @Generated
    public List<SQLToken> getSqlTokens() {
        return this.sqlTokens;
    }
}

