/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementSchemaRefresher
implements MetaDataRefresher<DropIndexStatement> {
    private static final String TYPE = DropIndexStatement.class.getName();

    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData database, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, DropIndexStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Collection<String> indexNames = this.getIndexNames(sqlStatement);
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement);
        String tableName = simpleTableSegment.map(tableSegment -> tableSegment.getTableName().getIdentifier().getValue()).orElse("");
        TableMetaData tableMetaData = schemaMetaData.getDefaultSchema().get(tableName);
        if (!Strings.isNullOrEmpty((String)tableName)) {
            for (String each : indexNames) {
                tableMetaData.getIndexes().remove(each);
            }
            this.post(schemaMetaData.getName(), tableMetaData);
            return;
        }
        for (String each : indexNames) {
            Optional<String> logicTableNameOptional = this.findLogicTableName(schemaMetaData.getDefaultSchema(), each);
            if (!logicTableNameOptional.isPresent()) continue;
            String logicTableName = logicTableNameOptional.orElse("");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logicTableName) ? 1 : 0) != 0, (Object)"Cannot get the table name!");
            if (null == tableMetaData) {
                tableMetaData = schemaMetaData.getDefaultSchema().get(logicTableName);
            }
            Preconditions.checkNotNull((Object)tableMetaData, (Object)"Cannot get the table metadata!");
            tableMetaData.getIndexes().remove(each);
        }
        this.post(schemaMetaData.getName(), tableMetaData);
    }

    private Collection<String> getIndexNames(DropIndexStatement dropIndexStatement) {
        return dropIndexStatement.getIndexes().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toCollection(LinkedList::new));
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String logicIndexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.get(each).getIndexes().containsKey(logicIndexName)).findFirst();
    }

    private void post(String schemaName, TableMetaData tableMetaData) {
        SchemaAlteredEvent event = new SchemaAlteredEvent(schemaName);
        event.getAlteredTables().add(tableMetaData);
        ShardingSphereEventBus.getInstance().post((Object)event);
    }

    public String getType() {
        return TYPE;
    }
}

