/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateIndexStatement;

public final class CreateIndexStatementSchemaRefresher
implements MetaDataRefresher<CreateIndexStatement> {
    private static final String TYPE = CreateIndexStatement.class.getName();

    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData database, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, CreateIndexStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String indexName;
        String string = indexName = null != sqlStatement.getIndex() ? sqlStatement.getIndex().getIdentifier().getValue() : IndexMetaDataUtil.getGeneratedLogicIndexName((Collection)sqlStatement.getColumns());
        if (Strings.isNullOrEmpty((String)indexName)) {
            return;
        }
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        schemaMetaData.getDefaultSchema().get(tableName).getIndexes().put(indexName, new IndexMetaData(indexName));
        SchemaAlteredEvent event = new SchemaAlteredEvent(schemaMetaData.getName());
        event.getAlteredTables().add(schemaMetaData.getDefaultSchema().get(tableName));
        ShardingSphereEventBus.getInstance().post((Object)event);
    }

    public String getType() {
        return TYPE;
    }
}

