/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class AlterIndexStatementSchemaRefresher
implements MetaDataRefresher<AlterIndexStatement> {
    private static final String TYPE = AlterIndexStatement.class.getName();

    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData database, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, AlterIndexStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional renameIndex = AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)sqlStatement);
        if (!sqlStatement.getIndex().isPresent() || !renameIndex.isPresent()) {
            return;
        }
        String indexName = ((IndexSegment)sqlStatement.getIndex().get()).getIdentifier().getValue();
        Optional<String> logicTableName = this.findLogicTableName(schemaMetaData.getDefaultSchema(), indexName);
        if (logicTableName.isPresent()) {
            TableMetaData tableMetaData = schemaMetaData.getDefaultSchema().get(logicTableName.get());
            Preconditions.checkNotNull((Object)tableMetaData, (String)"Can not get the table '%s' metadata!", (Object)logicTableName.get());
            tableMetaData.getIndexes().remove(indexName);
            String renameIndexName = ((IndexSegment)renameIndex.get()).getIdentifier().getValue();
            tableMetaData.getIndexes().put(renameIndexName, new IndexMetaData(renameIndexName));
            SchemaAlteredEvent event = new SchemaAlteredEvent(schemaMetaData.getName());
            event.getAlteredTables().add(tableMetaData);
            ShardingSphereEventBus.getInstance().post((Object)event);
        }
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String indexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.get(each).getIndexes().containsKey(indexName)).findFirst();
    }

    public String getType() {
        return TYPE;
    }
}

