/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class MetaDataRefreshEngine {
    private static final Set<Class<? extends SQLStatement>> IGNORABLE_SQL_STATEMENT_CLASSES;
    private final ShardingSphereMetaData schemaMetaData;
    private final FederationDatabaseMetaData federationMetaData;
    private final Map<String, OptimizerPlannerContext> optimizerPlanners;
    private final ConfigurationProperties props;

    public void refresh(SQLStatement sqlStatement, Supplier<Collection<String>> logicDataSourceNamesSupplier) throws SQLException {
        Class<?> sqlStatementClass = sqlStatement.getClass();
        if (IGNORABLE_SQL_STATEMENT_CLASSES.contains(sqlStatementClass)) {
            return;
        }
        Optional schemaRefresher = TypedSPIRegistry.findRegisteredService(MetaDataRefresher.class, (String)sqlStatementClass.getSuperclass().getName(), null);
        if (schemaRefresher.isPresent()) {
            ((MetaDataRefresher)schemaRefresher.get()).refresh(this.schemaMetaData, this.federationMetaData, this.optimizerPlanners, logicDataSourceNamesSupplier.get(), sqlStatement, this.props);
        } else {
            IGNORABLE_SQL_STATEMENT_CLASSES.add(sqlStatementClass);
        }
    }

    @Generated
    public MetaDataRefreshEngine(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData federationMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, ConfigurationProperties props) {
        this.schemaMetaData = schemaMetaData;
        this.federationMetaData = federationMetaData;
        this.optimizerPlanners = optimizerPlanners;
        this.props = props;
    }

    static {
        ShardingSphereServiceLoader.register(MetaDataRefresher.class);
        IGNORABLE_SQL_STATEMENT_CLASSES = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

