/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance.definition;

import com.google.common.base.Splitter;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.utils.IpUtils;

public final class InstanceId {
    private static final String DELIMITER = "@";
    private static final AtomicLong ATOMIC_LONG = new AtomicLong();
    private final String id;
    private final String ip;
    private final Integer uniqueSign;

    public InstanceId(String ip, Integer uniqueSign) {
        this.ip = ip;
        this.uniqueSign = uniqueSign;
        this.id = String.join((CharSequence)DELIMITER, ip, String.valueOf(uniqueSign));
    }

    public InstanceId(Integer uniqueSign) {
        this.uniqueSign = uniqueSign;
        this.ip = IpUtils.getIp();
        this.id = String.join((CharSequence)DELIMITER, this.ip, String.valueOf(uniqueSign));
    }

    public InstanceId(String id) {
        this.id = id;
        List ids = Splitter.on((String)DELIMITER).splitToList((CharSequence)id);
        this.ip = (String)ids.get(0);
        this.uniqueSign = Integer.valueOf((String)ids.get(1));
    }

    public InstanceId() {
        this.ip = IpUtils.getIp();
        this.uniqueSign = Integer.valueOf(String.join((CharSequence)"", ManagementFactory.getRuntimeMXBean().getName().split(DELIMITER)[0], String.valueOf(ATOMIC_LONG.incrementAndGet())));
        this.id = String.join((CharSequence)DELIMITER, this.ip, String.valueOf(this.uniqueSign));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getUniqueSign() {
        return this.uniqueSign;
    }
}

