/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;

public final class HintManager
implements AutoCloseable {
    private static final ThreadLocal<HintManager> HINT_MANAGER_HOLDER = new ThreadLocal();
    private final Multimap<String, Comparable<?>> databaseShardingValues = ArrayListMultimap.create();
    private final Multimap<String, Comparable<?>> tableShardingValues = ArrayListMultimap.create();
    private boolean databaseShardingOnly;
    private boolean writeRouteOnly;
    private String dataSourceName;

    public static HintManager getInstance() {
        Preconditions.checkState((null == HINT_MANAGER_HOLDER.get() ? 1 : 0) != 0, (Object)"Hint has previous value, please clear first.");
        HintManager result = new HintManager();
        HINT_MANAGER_HOLDER.set(result);
        return result;
    }

    public void setDatabaseShardingValue(Comparable<?> value) {
        this.databaseShardingValues.clear();
        this.tableShardingValues.clear();
        this.databaseShardingValues.put((Object)"", value);
        this.databaseShardingOnly = true;
    }

    public void addDatabaseShardingValue(String logicTable, Comparable<?> value) {
        if (this.databaseShardingOnly) {
            this.databaseShardingValues.removeAll((Object)"");
        }
        this.databaseShardingValues.put((Object)logicTable, value);
        this.databaseShardingOnly = false;
    }

    public void addTableShardingValue(String logicTable, Comparable<?> value) {
        if (this.databaseShardingOnly) {
            this.databaseShardingValues.removeAll((Object)"");
        }
        this.tableShardingValues.put((Object)logicTable, value);
        this.databaseShardingOnly = false;
    }

    public static Collection<Comparable<?>> getDatabaseShardingValues() {
        return HintManager.getDatabaseShardingValues("");
    }

    public static Collection<Comparable<?>> getDatabaseShardingValues(String logicTable) {
        return null == HINT_MANAGER_HOLDER.get() ? Collections.emptyList() : HintManager.HINT_MANAGER_HOLDER.get().databaseShardingValues.get((Object)logicTable);
    }

    public static Collection<Comparable<?>> getTableShardingValues(String logicTable) {
        return null == HINT_MANAGER_HOLDER.get() ? Collections.emptyList() : HintManager.HINT_MANAGER_HOLDER.get().tableShardingValues.get((Object)logicTable);
    }

    public static boolean isDatabaseShardingOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HintManager.HINT_MANAGER_HOLDER.get().databaseShardingOnly;
    }

    public void setWriteRouteOnly() {
        this.writeRouteOnly = true;
    }

    public void setReadwriteSplittingAuto() {
        this.writeRouteOnly = false;
    }

    public static boolean isWriteRouteOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HintManager.HINT_MANAGER_HOLDER.get().writeRouteOnly;
    }

    public static void clear() {
        HINT_MANAGER_HOLDER.remove();
    }

    public void clearShardingValues() {
        this.databaseShardingValues.clear();
        this.tableShardingValues.clear();
        this.databaseShardingOnly = false;
    }

    public static boolean isInstantiated() {
        return null != HINT_MANAGER_HOLDER.get();
    }

    public static Optional<String> getDataSourceName() {
        return Optional.ofNullable(HINT_MANAGER_HOLDER.get()).map(hintManager -> hintManager.dataSourceName);
    }

    @Override
    public void close() {
        HintManager.clear();
    }

    @Generated
    private HintManager() {
    }

    @Generated
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

