/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type.dialect;

import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.metadata.dialect.PostgreSQLDataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackStatement;

public final class PostgreSQLDatabaseType
implements DatabaseType {
    private static final Map<String, Collection<String>> SYSTEM_DATABASE_SCHEMA_MAP = new HashMap<String, Collection<String>>();
    private static final Collection<String> SYSTEM_SCHEMAS = Sets.newHashSet((Object[])new String[]{"information_schema", "pg_catalog"});

    @Override
    public String getName() {
        return "PostgreSQL";
    }

    @Override
    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.QUOTE;
    }

    @Override
    public Collection<String> getJdbcUrlPrefixes() {
        return Collections.singleton(String.format("jdbc:%s:", this.getName().toLowerCase()));
    }

    @Override
    public PostgreSQLDataSourceMetaData getDataSourceMetaData(String url, String username) {
        return new PostgreSQLDataSourceMetaData(url);
    }

    @Override
    public Optional<String> getDataSourceClassName() {
        return Optional.of("org.postgresql.ds.PGSimpleDataSource");
    }

    @Override
    public void handleRollbackOnly(boolean rollbackOnly, SQLStatement statement) throws SQLException {
        if (rollbackOnly && !(statement instanceof CommitStatement) && !(statement instanceof RollbackStatement)) {
            throw new SQLFeatureNotSupportedException("Current transaction is aborted, commands ignored until end of transaction block.");
        }
    }

    @Override
    public Map<String, Collection<String>> getSystemDatabaseSchemaMap() {
        return SYSTEM_DATABASE_SCHEMA_MAP;
    }

    @Override
    public Collection<String> getSystemSchemas() {
        return SYSTEM_SCHEMAS;
    }

    static {
        SYSTEM_DATABASE_SCHEMA_MAP.put("postgres", SYSTEM_SCHEMAS);
    }
}

