/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;

public final class DatabaseTypeFactory {
    public static DatabaseType getDatabaseType(Map<String, ? extends SchemaConfiguration> schemaConfigs, ConfigurationProperties props) {
        Optional<DatabaseType> configuredDatabaseType = DatabaseTypeFactory.findConfiguredDatabaseType(props);
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        Collection dataSources = schemaConfigs.values().stream().filter(DatabaseTypeFactory::isComplete).findFirst().map(optional -> optional.getDataSources().values()).orElseGet(Collections::emptyList);
        return DatabaseTypeRecognizer.getDatabaseType(dataSources);
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        String configuredDatabaseType = (String)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return configuredDatabaseType.isEmpty() ? Optional.empty() : Optional.of(DatabaseTypeRegistry.getTrunkDatabaseType(configuredDatabaseType));
    }

    private static boolean isComplete(SchemaConfiguration schemaConfig) {
        return !schemaConfig.getRuleConfigurations().isEmpty() && !schemaConfig.getDataSources().isEmpty();
    }

    @Generated
    private DatabaseTypeFactory() {
    }
}

