/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dal;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dal.ExplainStatementHandler;

public final class ExplainStatementContext
extends CommonSQLStatementContext<ExplainStatement>
implements TableAvailable {
    private final TablesContext tablesContext;

    public ExplainStatementContext(ExplainStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(this.extractTablesFromExplain(sqlStatement), this.getDatabaseType());
    }

    private Collection<SimpleTableSegment> extractTablesFromExplain(ExplainStatement sqlStatement) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        ExplainStatementHandler.getSimpleTableSegment((ExplainStatement)sqlStatement).ifPresent(result::add);
        SQLStatement explainableStatement = sqlStatement.getStatement().orElse(null);
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSQLStatement(explainableStatement);
        result.addAll(extractor.getRewriteTables());
        return result;
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.extractTablesFromExplain((ExplainStatement)this.getSqlStatement());
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

