/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;

public class AggregationProjection
implements Projection {
    private final AggregationType type;
    private final String innerExpression;
    private final String alias;
    private final DatabaseType databaseType;
    private final List<AggregationProjection> derivedAggregationProjections = new ArrayList<AggregationProjection>(2);
    private int index = -1;

    @Override
    public final String getExpression() {
        return this.type.name() + this.innerExpression;
    }

    @Override
    public final Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public String getColumnLabel() {
        boolean isPostgreSQLOpenGaussStatement = this.databaseType instanceof PostgreSQLDatabaseType || this.databaseType instanceof OpenGaussDatabaseType;
        return this.getAlias().orElseGet(() -> isPostgreSQLOpenGaussStatement ? this.type.name() : this.getExpression());
    }

    @Generated
    public AggregationProjection(AggregationType type, String innerExpression, String alias, DatabaseType databaseType) {
        this.type = type;
        this.innerExpression = innerExpression;
        this.alias = alias;
        this.databaseType = databaseType;
    }

    @Generated
    public AggregationType getType() {
        return this.type;
    }

    @Generated
    public String getInnerExpression() {
        return this.innerExpression;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public List<AggregationProjection> getDerivedAggregationProjections() {
        return this.derivedAggregationProjections;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationProjection)) {
            return false;
        }
        AggregationProjection other = (AggregationProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        AggregationType this$type = this.getType();
        AggregationType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$innerExpression = this.getInnerExpression();
        String other$innerExpression = other.getInnerExpression();
        if (this$innerExpression == null ? other$innerExpression != null : !this$innerExpression.equals(other$innerExpression)) {
            return false;
        }
        Optional<String> this$alias = this.getAlias();
        Optional<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        DatabaseType this$databaseType = this.getDatabaseType();
        DatabaseType other$databaseType = other.getDatabaseType();
        if (this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType)) {
            return false;
        }
        List<AggregationProjection> this$derivedAggregationProjections = this.getDerivedAggregationProjections();
        List<AggregationProjection> other$derivedAggregationProjections = other.getDerivedAggregationProjections();
        return !(this$derivedAggregationProjections == null ? other$derivedAggregationProjections != null : !((Object)this$derivedAggregationProjections).equals(other$derivedAggregationProjections));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggregationProjection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        AggregationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $innerExpression = this.getInnerExpression();
        result = result * 59 + ($innerExpression == null ? 43 : $innerExpression.hashCode());
        Optional<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        DatabaseType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        List<AggregationProjection> $derivedAggregationProjections = this.getDerivedAggregationProjections();
        result = result * 59 + ($derivedAggregationProjections == null ? 43 : ((Object)$derivedAggregationProjections).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AggregationProjection(type=" + this.getType() + ", innerExpression=" + this.getInnerExpression() + ", alias=" + this.getAlias() + ", databaseType=" + this.getDatabaseType() + ", derivedAggregationProjections=" + this.getDerivedAggregationProjections() + ", index=" + this.getIndex() + ")";
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }
}

