/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseDiscoveryType
implements DatabaseDiscoveryType {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabaseDiscoveryType.class);
    private String oldPrimaryDataSource;

    protected abstract String getPrimaryDataSourceURL(Statement var1) throws SQLException;

    public void updatePrimaryDataSource(String schemaName, Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames, String groupName) {
        String newPrimaryDataSource;
        HashMap<String, DataSource> activeDataSourceMap = new HashMap<String, DataSource>(dataSourceMap);
        if (!disabledDataSourceNames.isEmpty()) {
            activeDataSourceMap.entrySet().removeIf(each -> disabledDataSourceNames.contains(each.getKey()));
        }
        if ((newPrimaryDataSource = this.determinePrimaryDataSource(activeDataSourceMap)).isEmpty()) {
            return;
        }
        if (!newPrimaryDataSource.equals(this.oldPrimaryDataSource)) {
            this.oldPrimaryDataSource = newPrimaryDataSource;
            ShardingSphereEventBus.getInstance().post((Object)new PrimaryDataSourceChangedEvent(new QualifiedSchema(schemaName, groupName, newPrimaryDataSource)));
        }
    }

    private String determinePrimaryDataSource(Map<String, DataSource> dataSourceMap) {
        String primaryDataSourceURL = this.findPrimaryDataSourceURL(dataSourceMap);
        return this.findPrimaryDataSourceName(primaryDataSourceURL, dataSourceMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPrimaryDataSourceURL(Map<String, DataSource> dataSourceMap) {
        Iterator<DataSource> iterator = dataSourceMap.values().iterator();
        while (iterator.hasNext()) {
            DataSource each = iterator.next();
            try {
                Connection connection = each.getConnection();
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        String primaryDataSourceURL = this.getPrimaryDataSourceURL(statement);
                        if (primaryDataSourceURL.isEmpty()) continue;
                        String string = primaryDataSourceURL;
                        return string;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find primary data source url", (Throwable)ex);
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPrimaryDataSourceName(String primaryDataSourceURL, Map<String, DataSource> dataSourceMap) {
        String result = "";
        Iterator<Map.Entry<String, DataSource>> iterator = dataSourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataSource> entry = iterator.next();
            try {
                Connection connection = entry.getValue().getConnection();
                Throwable throwable = null;
                try {
                    String url = connection.getMetaData().getURL();
                    if (null == url || !url.contains(primaryDataSourceURL)) continue;
                    String string = entry.getKey();
                    return string;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find primary data source name", (Throwable)ex);
            }
        }
        return result;
    }

    public String getPrimaryDataSource() {
        return this.oldPrimaryDataSource;
    }
}

