/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryHeartbeatSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public final class CreateDatabaseDiscoveryHeartbeatStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDatabaseDiscoveryHeartbeatStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public DatabaseDiscoveryRuleConfiguration buildToBeCreatedRuleConfiguration(CreateDatabaseDiscoveryHeartbeatStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryHeartbeat(sqlStatement.getHeartbeats());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryHeartbeats().putAll(toBeCreatedRuleConfig.getDiscoveryHeartbeats());
        }
    }

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, CreateDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkDuplicateHeartbeat(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkDuplicateHeartbeat(String schemaName, CreateDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig) {
            return;
        }
        Set existRuleNames = currentRuleConfig.getDiscoveryHeartbeats().keySet();
        Collection duplicateRuleNames = sqlStatement.getHeartbeats().stream().map(DatabaseDiscoveryHeartbeatSegment::getHeartbeatName).filter(existRuleNames::contains).collect(Collectors.toSet());
        duplicateRuleNames.addAll(this.getToBeCreatedDuplicateRuleNames(sqlStatement));
        DistSQLException.predictionThrow((boolean)duplicateRuleNames.isEmpty(), () -> new DuplicateRuleException(RULE_TYPE, schemaName, duplicateRuleNames));
    }

    private Collection<String> getToBeCreatedDuplicateRuleNames(CreateDatabaseDiscoveryHeartbeatStatement sqlStatement) {
        return sqlStatement.getHeartbeats().stream().collect(Collectors.toMap(DatabaseDiscoveryHeartbeatSegment::getHeartbeatName, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return CreateDatabaseDiscoveryHeartbeatStatement.class.getName();
    }
}

