/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.converter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.AbstractDatabaseDiscoverySegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryConstructionSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryDefinitionSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryHeartbeatSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryTypeSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;

public final class DatabaseDiscoveryRuleStatementConverter {
    public static DatabaseDiscoveryRuleConfiguration convert(Collection<AbstractDatabaseDiscoverySegment> ruleSegments) {
        Map<String, List<AbstractDatabaseDiscoverySegment>> segmentMap = ruleSegments.stream().collect(Collectors.groupingBy(each -> each.getClass().getSimpleName()));
        DatabaseDiscoveryRuleConfiguration result = new DatabaseDiscoveryRuleConfiguration(new LinkedList(), new LinkedHashMap(), new LinkedHashMap());
        segmentMap.getOrDefault(DatabaseDiscoveryDefinitionSegment.class.getSimpleName(), Collections.emptyList()).forEach(each -> DatabaseDiscoveryRuleStatementConverter.addConfiguration(result, (DatabaseDiscoveryDefinitionSegment)each));
        segmentMap.getOrDefault(DatabaseDiscoveryConstructionSegment.class.getSimpleName(), Collections.emptyList()).forEach(each -> DatabaseDiscoveryRuleStatementConverter.addConfiguration(result, (DatabaseDiscoveryConstructionSegment)each));
        return result;
    }

    private static void addConfiguration(DatabaseDiscoveryRuleConfiguration configuration, DatabaseDiscoveryDefinitionSegment segment) {
        String discoveryTypeName = DatabaseDiscoveryRuleStatementConverter.getName(segment.getName(), segment.getDiscoveryType().getName());
        ShardingSphereAlgorithmConfiguration discoveryType = new ShardingSphereAlgorithmConfiguration(segment.getDiscoveryType().getName(), segment.getDiscoveryType().getProps());
        String heartbeatName = DatabaseDiscoveryRuleStatementConverter.getName(segment.getName(), "heartbeat");
        DatabaseDiscoveryHeartBeatConfiguration heartbeatConfiguration = new DatabaseDiscoveryHeartBeatConfiguration(segment.getDiscoveryHeartbeat());
        DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfiguration = new DatabaseDiscoveryDataSourceRuleConfiguration(segment.getName(), new LinkedList(segment.getDataSources()), heartbeatName, discoveryTypeName);
        configuration.getDataSources().add(dataSourceRuleConfiguration);
        configuration.getDiscoveryTypes().put(discoveryTypeName, discoveryType);
        configuration.getDiscoveryHeartbeats().put(heartbeatName, heartbeatConfiguration);
    }

    private static void addConfiguration(DatabaseDiscoveryRuleConfiguration configuration, DatabaseDiscoveryConstructionSegment segment) {
        DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfiguration = new DatabaseDiscoveryDataSourceRuleConfiguration(segment.getName(), new LinkedList(segment.getDataSources()), segment.getDiscoveryHeartbeatName(), segment.getDiscoveryTypeName());
        configuration.getDataSources().add(dataSourceRuleConfiguration);
    }

    private static String getName(String ruleName, String type) {
        return String.format("%s_%s", ruleName, type);
    }

    public static DatabaseDiscoveryRuleConfiguration convertDiscoveryHeartbeat(Collection<DatabaseDiscoveryHeartbeatSegment> heartbeatSegments) {
        DatabaseDiscoveryRuleConfiguration result = new DatabaseDiscoveryRuleConfiguration(new LinkedList(), new LinkedHashMap(), new LinkedHashMap());
        heartbeatSegments.forEach(each -> result.getDiscoveryHeartbeats().put(each.getHeartbeatName(), new DatabaseDiscoveryHeartBeatConfiguration(each.getProperties())));
        return result;
    }

    public static DatabaseDiscoveryRuleConfiguration convertDiscoveryType(Collection<DatabaseDiscoveryTypeSegment> typeSegment) {
        DatabaseDiscoveryRuleConfiguration result = new DatabaseDiscoveryRuleConfiguration(new LinkedList(), new LinkedHashMap(), new LinkedHashMap());
        typeSegment.forEach(each -> result.getDiscoveryTypes().put(each.getDiscoveryTypeName(), new ShardingSphereAlgorithmConfiguration(each.getAlgorithmSegment().getName(), each.getAlgorithmSegment().getProps())));
        return result;
    }

    @Generated
    private DatabaseDiscoveryRuleStatementConverter() {
    }
}

