/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.shardingjdbc.spring.datasource.SpringMasterSlaveDataSource;
import org.apache.shardingsphere.shardingjdbc.spring.namespace.parser.MasterSlaveRuleConfigurationBeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class MasterSlaveDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringMasterSlaveDataSource.class);
        MasterSlaveRuleConfigurationBeanDefinition configurationBeanDefinition = new MasterSlaveRuleConfigurationBeanDefinition(element);
        factory.addConstructorArgValue(this.parseDataSources(configurationBeanDefinition));
        factory.addConstructorArgValue((Object)configurationBeanDefinition.getBeanDefinition());
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        return factory.getBeanDefinition();
    }

    private Map<String, RuntimeBeanReference> parseDataSources(MasterSlaveRuleConfigurationBeanDefinition configurationBeanDefinition) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)configurationBeanDefinition.getSlaveDataSourceNames());
        ManagedMap result = new ManagedMap(slaveDataSources.size());
        for (String each : slaveDataSources) {
            result.put(each, new RuntimeBeanReference(each));
        }
        String masterDataSourceName = configurationBeanDefinition.getMasterDataSourceName();
        result.put(masterDataSourceName, new RuntimeBeanReference(masterDataSourceName));
        return result;
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

