/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure;

import javax.sql.DataSource;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.rm.fence.SpringFenceConfig;
import org.apache.seata.spring.boot.autoconfigure.SeataCoreAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnExpression(value="${seata.enabled:true}")
@ConditionalOnBean(type={"javax.sql.DataSource", "org.springframework.transaction.PlatformTransactionManager"})
@ConditionalOnMissingBean(value={SpringFenceConfig.class})
@AutoConfigureAfter(value={SeataCoreAutoConfiguration.class, TransactionAutoConfiguration.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
public class SeataSpringFenceAutoConfiguration {
    public static final String SPRING_FENCE_DATA_SOURCE_BEAN_NAME = "seataSpringFenceDataSource";
    public static final String SPRING_FENCE_TRANSACTION_MANAGER_BEAN_NAME = "seataSpringFenceTransactionManager";

    @Bean
    @ConfigurationProperties(value="seata.tcc.fence")
    public SpringFenceConfig springFenceConfig(DataSource dataSource, PlatformTransactionManager transactionManager, @Qualifier(value="seataSpringFenceDataSource") @Autowired(required=false) DataSource springFenceDataSource, @Qualifier(value="seataSpringFenceTransactionManager") @Autowired(required=false) PlatformTransactionManager springFenceTransactionManager) {
        SpringFenceConfig springFenceConfig = new SpringFenceConfig(springFenceDataSource != null ? springFenceDataSource : dataSource, springFenceTransactionManager != null ? springFenceTransactionManager : transactionManager);
        ObjectHolder.INSTANCE.setObject("SpringFenceConfig", (Object)springFenceConfig);
        return springFenceConfig;
    }
}

