/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.tm.api;

import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.tm.api.DefaultGlobalTransaction;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.GlobalTransactionRole;

public class GlobalTransactionContext {
    private GlobalTransactionContext() {
    }

    public static GlobalTransaction createNew() {
        return new DefaultGlobalTransaction();
    }

    public static GlobalTransaction getCurrent() {
        String xid = RootContext.getXID();
        if (xid == null) {
            return null;
        }
        return new DefaultGlobalTransaction(xid, GlobalStatus.Begin, GlobalTransactionRole.Participant);
    }

    public static GlobalTransaction getCurrentOrCreate() {
        GlobalTransaction tx = GlobalTransactionContext.getCurrent();
        if (tx == null) {
            return GlobalTransactionContext.createNew();
        }
        return tx;
    }

    public static GlobalTransaction reload(String xid) throws TransactionException {
        return new DefaultGlobalTransaction(xid, GlobalStatus.UnKnown, GlobalTransactionRole.Launcher){

            @Override
            public void begin(int timeout, String name) throws TransactionException {
                throw new IllegalStateException("Never BEGIN on a RELOADED GlobalTransaction. ");
            }
        };
    }
}

