/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.tm.api;

import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.TransactionManager;
import org.apache.seata.tm.TransactionManagerHolder;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.GlobalTransactionRole;
import org.apache.seata.tm.api.transaction.SuspendedResourcesHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalTransaction
implements GlobalTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGlobalTransaction.class);
    private static final int DEFAULT_GLOBAL_TX_TIMEOUT = 60000;
    private static final String DEFAULT_GLOBAL_TX_NAME = "default";
    private TransactionManager transactionManager = TransactionManagerHolder.get();
    private String xid;
    private GlobalStatus status;
    private GlobalTransactionRole role;
    private long createTime;
    private static final int COMMIT_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.tm.commitRetryCount", 5);
    private static final int ROLLBACK_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.tm.rollbackRetryCount", 5);

    DefaultGlobalTransaction() {
        this(null, GlobalStatus.UnKnown, GlobalTransactionRole.Launcher);
    }

    public DefaultGlobalTransaction(String xid, GlobalStatus status, GlobalTransactionRole role) {
        this.xid = xid;
        this.status = status;
        this.role = role;
    }

    @Override
    public void begin() throws TransactionException {
        this.begin(60000);
    }

    @Override
    public void begin(int timeout) throws TransactionException {
        this.begin(timeout, DEFAULT_GLOBAL_TX_NAME);
    }

    @Override
    public void begin(int timeout, String name) throws TransactionException {
        this.createTime = System.currentTimeMillis();
        if (this.role != GlobalTransactionRole.Launcher) {
            this.assertXIDNotNull();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Begin(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        this.assertXIDNull();
        String currentXid = RootContext.getXID();
        if (currentXid != null) {
            throw new IllegalStateException("Global transaction already exists, can't begin a new global transaction, currentXid = " + currentXid);
        }
        this.xid = this.transactionManager.begin(null, null, name, timeout);
        this.status = GlobalStatus.Begin;
        RootContext.bind(this.xid);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin new global transaction [{}]", (Object)this.xid);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Commit(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        this.assertXIDNotNull();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("transaction {} will be commit", (Object)this.xid);
        }
        int retry = COMMIT_RETRY_COUNT <= 0 ? 5 : COMMIT_RETRY_COUNT;
        try {
            while (retry > 0) {
                try {
                    --retry;
                    this.status = this.transactionManager.commit(this.xid);
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to report global commit [{}],Retry Countdown: {}, reason: {}", new Object[]{this.getXid(), retry, ex.getMessage()});
                    if (retry != 0) continue;
                    throw new TransactionException("Failed to report global commit", ex);
                }
            }
        }
        finally {
            if (this.xid.equals(RootContext.getXID())) {
                this.suspend(true);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] commit status: {}", (Object)this.xid, (Object)this.status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Rollback(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        this.assertXIDNotNull();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("transaction {} will be rollback", (Object)this.xid);
        }
        int retry = ROLLBACK_RETRY_COUNT <= 0 ? 5 : ROLLBACK_RETRY_COUNT;
        try {
            while (retry > 0) {
                try {
                    --retry;
                    this.status = this.transactionManager.rollback(this.xid);
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to report global rollback [{}],Retry Countdown: {}, reason: {}", new Object[]{this.getXid(), retry, ex.getMessage()});
                    if (retry != 0) continue;
                    throw new TransactionException("Failed to report global rollback", ex);
                }
            }
        }
        finally {
            if (this.xid.equals(RootContext.getXID())) {
                this.suspend(true);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] rollback status: {}", (Object)this.xid, (Object)this.status);
        }
    }

    @Override
    public SuspendedResourcesHolder suspend() throws TransactionException {
        return this.suspend(false);
    }

    @Override
    public SuspendedResourcesHolder suspend(boolean clean) throws TransactionException {
        String xid = RootContext.getXID();
        if (xid != null) {
            if (LOGGER.isInfoEnabled()) {
                if (clean) {
                    LOGGER.info("transaction end, xid = {}", (Object)xid);
                } else {
                    LOGGER.info("suspending current transaction, xid = {}", (Object)xid);
                }
            }
            RootContext.unbind();
            return clean ? null : new SuspendedResourcesHolder(xid);
        }
        return null;
    }

    @Override
    public void resume(SuspendedResourcesHolder suspendedResourcesHolder) throws TransactionException {
        if (suspendedResourcesHolder == null) {
            return;
        }
        String xid = suspendedResourcesHolder.getXid();
        RootContext.bind(xid);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resuming the transaction,xid = {}", (Object)xid);
        }
    }

    @Override
    public GlobalStatus getStatus() throws TransactionException {
        if (this.xid == null) {
            return GlobalStatus.UnKnown;
        }
        this.status = this.transactionManager.getStatus(this.xid);
        return this.status;
    }

    @Override
    public String getXid() {
        return this.xid;
    }

    @Override
    public void globalReport(GlobalStatus globalStatus) throws TransactionException {
        this.assertXIDNotNull();
        if (globalStatus == null) {
            throw new IllegalStateException();
        }
        this.status = this.transactionManager.globalReport(this.xid, globalStatus);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] report status: {}", (Object)this.xid, (Object)this.status);
        }
        if (this.xid.equals(RootContext.getXID())) {
            this.suspend(true);
        }
    }

    @Override
    public GlobalStatus getLocalStatus() {
        return this.status;
    }

    @Override
    public GlobalTransactionRole getGlobalTransactionRole() {
        return this.role;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    private void assertXIDNotNull() {
        if (this.xid == null) {
            throw new IllegalStateException();
        }
    }

    private void assertXIDNull() {
        if (this.xid != null) {
            throw new IllegalStateException();
        }
    }
}

