/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.sqlparser.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.sqlparser.EscapeHandler;
import org.apache.seata.sqlparser.EscapeHandlerFactory;
import org.apache.seata.sqlparser.struct.TableMeta;

public final class ColumnUtils {
    public static List<String> delEscape(List<String> cols, String dbType) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.delEscape(col, dbType);
            newCols.add(col);
        }
        return newCols;
    }

    public static String delEscape(String colName, String dbType) {
        EscapeHandler escapeHandler = EscapeHandlerFactory.getEscapeHandler(dbType);
        return escapeHandler.delColNameEscape(colName);
    }

    public static List<String> addEscape(List<String> cols, String dbType) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.addEscape(col, dbType);
            newCols.add(col);
        }
        return newCols;
    }

    public static String addEscape(String colName, String dbType) {
        return ColumnUtils.addEscape(colName, dbType, null);
    }

    public static String addEscape(String colName, String dbType, TableMeta tableMeta) {
        if (StringUtils.isBlank(colName)) {
            return colName;
        }
        EscapeHandler escapeHandler = EscapeHandlerFactory.getEscapeHandler(dbType);
        return escapeHandler.addColNameEscape(colName, tableMeta);
    }
}

