/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.annotation.datasource;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.rm.datasource.SeataDataSourceProxy;
import org.apache.seata.spring.annotation.datasource.DataSourceProxyHolder;
import org.apache.seata.spring.annotation.datasource.SeataProxy;
import org.springframework.aop.IntroductionInfo;

public class SeataAutoDataSourceProxyAdvice
implements MethodInterceptor,
IntroductionInfo {
    private final BranchType branchType;
    private final Class<?>[] attachedInterfaces = new Class[]{SeataProxy.class};

    public SeataAutoDataSourceProxyAdvice(String dataSourceProxyMode) {
        this.branchType = BranchType.get(dataSourceProxyMode);
        RootContext.setDefaultBranchType(this.branchType);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method declared;
        if (!this.inExpectedContext()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        try {
            declared = DataSource.class.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return invocation.proceed();
        }
        DataSource origin = (DataSource)invocation.getThis();
        SeataDataSourceProxy proxy = DataSourceProxyHolder.get(origin);
        Object[] args = invocation.getArguments();
        return declared.invoke((Object)proxy, args);
    }

    public Class<?>[] getInterfaces() {
        return this.attachedInterfaces;
    }

    boolean inExpectedContext() {
        if (RootContext.requireGlobalLock()) {
            return true;
        }
        if (!RootContext.inGlobalTransaction()) {
            return false;
        }
        return this.branchType == RootContext.getBranchType();
    }
}

