/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.BatchResultMessage;
import org.apache.seata.serializer.seata.MessageCodecFactory;
import org.apache.seata.serializer.seata.MessageSeataCodec;
import org.apache.seata.serializer.seata.protocol.AbstractMessageCodec;

public class BatchResultMessageCodec
extends AbstractMessageCodec {
    private byte version;

    public BatchResultMessageCodec(byte version) {
        this.version = version;
    }

    @Override
    public Class<?> getMessageClassType() {
        return BatchResultMessage.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        BatchResultMessage batchResultMessage = (BatchResultMessage)t;
        List<AbstractResultMessage> msgs = batchResultMessage.getResultMessages();
        List<Integer> msgIds = batchResultMessage.getMsgIds();
        ByteBuf buffer = Unpooled.buffer((int)1024);
        buffer.writeInt(0);
        buffer.writeShort((int)((short)msgs.size()));
        for (AbstractMessage abstractMessage : msgs) {
            ByteBuf subBuffer = Unpooled.buffer((int)1024);
            short typeCode = abstractMessage.getTypeCode();
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode, this.version);
            messageCodec.encode(abstractMessage, subBuffer);
            buffer.writeShort((int)abstractMessage.getTypeCode());
            buffer.writeBytes(subBuffer);
        }
        for (Integer n : msgIds) {
            buffer.writeInt(n.intValue());
        }
        int length = buffer.readableBytes();
        byte[] byArray = new byte[length];
        buffer.setInt(0, length - 4);
        buffer.readBytes(byArray);
        if (msgs.size() > 20 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("msg in one packet:" + msgs.size() + ",buffer size:" + byArray.length);
        }
        out.writeBytes(byArray);
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        BatchResultMessage batchResultMessage = (BatchResultMessage)t;
        if (in.remaining() < 4) {
            return;
        }
        int length = in.getInt();
        if (in.remaining() < length) {
            return;
        }
        byte[] buffer = new byte[length];
        in.get(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.decode(batchResultMessage, byteBuffer);
    }

    protected void decode(BatchResultMessage batchResultMessage, ByteBuffer byteBuffer) {
        int idx;
        int msgNum = byteBuffer.getShort();
        ArrayList<AbstractResultMessage> msgs = new ArrayList<AbstractResultMessage>();
        ArrayList<Integer> msgIds = new ArrayList<Integer>();
        for (idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            AbstractMessage abstractResultMessage = MessageCodecFactory.getMessage(typeCode);
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode, this.version);
            messageCodec.decode(abstractResultMessage, byteBuffer);
            msgs.add((AbstractResultMessage)abstractResultMessage);
        }
        for (idx = 0; idx < msgNum; ++idx) {
            msgIds.add(byteBuffer.getInt());
        }
        batchResultMessage.setResultMessages(msgs);
        batchResultMessage.setMsgIds(msgIds);
    }
}

