/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.fastjson2.Fastjson2SerializerFactory;

@LoadLevel(name="FASTJSON2")
public class Fastjson2Serializer
implements Serializer {
    @Override
    public <T> byte[] serialize(T t) {
        return JSONB.toBytes(t, (JSONWriter.Feature[])Fastjson2SerializerFactory.getInstance().getJsonWriterFeatureList());
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        return (T)JSONB.parseObject((byte[])bytes, Object.class, (Filter)Fastjson2SerializerFactory.getInstance().getFilter(), (JSONReader.Feature[])Fastjson2SerializerFactory.getInstance().getJsonReaderFeatureList());
    }
}

