/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.validator;

import java.util.List;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.validator.Rule;
import org.apache.seata.saga.statelang.validator.RuleFactory;
import org.apache.seata.saga.statelang.validator.ValidationException;

public class StateMachineValidator {
    public void validate(StateMachine stateMachine) throws ValidationException {
        List<Rule> rules = RuleFactory.getRules();
        for (Rule rule : rules) {
            boolean pass;
            try {
                pass = rule.validate(stateMachine);
            }
            catch (Throwable e) {
                throw new ValidationException(rule, "Exception occurs", e);
            }
            if (pass) continue;
            throw new ValidationException(rule, "Failed");
        }
    }
}

