/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.parser.utils;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.statelang.domain.ChoiceState;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.TaskState;

public class StateMachineUtils {
    public static Set<String> getAllPossibleSubsequentStates(State state) {
        HashSet<String> subsequentStates = new HashSet<String>();
        subsequentStates.add(state.getNext());
        switch (state.getType()) {
            case SCRIPT_TASK: 
            case SERVICE_TASK: 
            case SUB_STATE_MACHINE: 
            case SUB_MACHINE_COMPENSATION: {
                Optional.ofNullable(((TaskState)state).getCatches()).ifPresent(c -> c.forEach(e -> subsequentStates.add(e.getNext())));
                break;
            }
            case CHOICE: {
                Optional.ofNullable(((ChoiceState)state).getChoices()).ifPresent(c -> c.forEach(e -> subsequentStates.add(e.getNext())));
                subsequentStates.add(((ChoiceState)state).getDefault());
                break;
            }
        }
        return subsequentStates.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }
}

