/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.utils;

import java.util.Map;
import org.apache.seata.saga.engine.AsyncCallback;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.StateMachineEngine;
import org.apache.seata.saga.proctrl.Instruction;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.ProcessType;
import org.apache.seata.saga.proctrl.impl.ProcessContextImpl;
import org.apache.seata.saga.statelang.domain.StateInstance;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;

public class ProcessContextBuilder {
    private ProcessContextImpl processContext = new ProcessContextImpl();

    private ProcessContextBuilder() {
    }

    public static ProcessContextBuilder create() {
        return new ProcessContextBuilder();
    }

    public ProcessContext build() {
        return this.processContext;
    }

    public ProcessContextBuilder withProcessType(ProcessType processType) {
        if (processType != null) {
            this.processContext.setVariable("_ProcessType_", (Object)processType);
        }
        return this;
    }

    public ProcessContextBuilder withAsyncCallback(AsyncCallback asyncCallback) {
        if (asyncCallback != null) {
            this.processContext.setVariable("_async_callback_", asyncCallback);
        }
        return this;
    }

    public ProcessContextBuilder withInstruction(Instruction instruction) {
        if (instruction != null) {
            this.processContext.setInstruction(instruction);
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineInstance(StateMachineInstance stateMachineInstance) {
        if (stateMachineInstance != null) {
            this.processContext.setVariable("_current_statemachine_instance_", stateMachineInstance);
            this.processContext.setVariable("_current_statemachine_", stateMachineInstance.getStateMachine());
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineEngine(StateMachineEngine stateMachineEngine) {
        if (stateMachineEngine != null) {
            this.processContext.setVariable("_current_statemachine_engine_", stateMachineEngine);
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineConfig(StateMachineConfig stateMachineConfig) {
        if (stateMachineConfig != null) {
            this.processContext.setVariable("_statemachine_config_", stateMachineConfig);
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineContextVariables(Map<String, Object> contextVariables) {
        if (contextVariables != null) {
            this.processContext.setVariable("context", contextVariables);
        }
        return this;
    }

    public ProcessContextBuilder withOperationName(String operationName) {
        if (operationName != null) {
            this.processContext.setVariable("_operation_name_", operationName);
        }
        return this;
    }

    public ProcessContextBuilder withStateInstance(StateInstance stateInstance) {
        if (stateInstance != null) {
            this.processContext.setVariable("_current_state_instance_", stateInstance);
        }
        return this;
    }

    public ProcessContextBuilder withIsAsyncExecution(boolean isAsyncExecution) {
        this.processContext.setVariable("_is_async_execution_", isAsyncExecution);
        return this;
    }
}

