/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.interceptors;

import java.util.Map;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.InterceptableStateHandler;
import org.apache.seata.saga.engine.pcext.StateHandlerInterceptor;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;
import org.apache.seata.tm.api.GlobalTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="InSagaBranch", order=50)
public class InSagaBranchHandlerInterceptor
implements StateHandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InSagaBranchHandlerInterceptor.class);

    @Override
    public boolean match(Class<? extends InterceptableStateHandler> clazz) {
        return clazz != null;
    }

    @Override
    public void preProcess(ProcessContext context) throws EngineExecutionException {
        String previousXid;
        String xid = this.getXidFromProcessContext(context);
        if (StringUtils.isBlank(xid)) {
            LOGGER.warn("There is no xid in the process context.");
            return;
        }
        if (LOGGER.isWarnEnabled() && (previousXid = RootContext.getXID()) != null && !StringUtils.equalsIgnoreCase(previousXid, xid)) {
            LOGGER.warn("xid in change from {} to {}, Please don't use state machine engine in other global transaction.", (Object)previousXid, (Object)xid);
        }
        RootContext.bind(xid);
        RootContext.bindBranchType(BranchType.SAGA);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] Begin process the state instance in the saga branch.", (Object)xid);
        }
    }

    @Override
    public void postProcess(ProcessContext context, Exception exp) throws EngineExecutionException {
        String xid = RootContext.unbind();
        RootContext.unbindBranchType();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] Finish process the state instance in the saga branch.", (Object)xid);
        }
    }

    protected String getXidFromProcessContext(ProcessContext context) {
        String xid = null;
        Map contextVariable = (Map)context.getVariable("context");
        if (contextVariable != null && contextVariable.containsKey("_global_transaction_")) {
            GlobalTransaction globalTransaction = (GlobalTransaction)contextVariable.get("_global_transaction_");
            xid = globalTransaction.getXid();
        } else {
            StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
            if (stateMachineInstance != null) {
                xid = stateMachineInstance.getId();
            }
        }
        return xid;
    }
}

