/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.handlers;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.StateHandler;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.engine.pcext.utils.LoopContextHolder;
import org.apache.seata.saga.engine.pcext.utils.LoopTaskUtils;
import org.apache.seata.saga.proctrl.HierarchicalProcessContext;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.impl.ProcessContextImpl;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;
import org.apache.seata.saga.statelang.domain.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopStartStateHandler
implements StateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopStartStateHandler.class);
    private static final int AWAIT_TIMEOUT = 1000;

    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        instruction.setTemporaryState(null);
        TaskState.Loop loop = LoopTaskUtils.getLoopConfig(context, instruction.getState(context));
        LoopContextHolder loopContextHolder = LoopContextHolder.getCurrent(context, true);
        Semaphore semaphore = null;
        int maxInstances = 0;
        ArrayList<ProcessContext> loopContextList = new ArrayList<ProcessContext>();
        if (null != loop) {
            int totalInstances;
            if (!stateMachineConfig.isEnableAsync() || null == stateMachineConfig.getAsyncProcessCtrlEventPublisher()) {
                throw new EngineExecutionException("Asynchronous start is disabled. Loop execution will run asynchronous, please set StateMachineConfig.enableAsync=true first.", FrameworkErrorCode.AsynchronousStartDisabled);
            }
            if ("forward".equals(context.getVariable("_operation_name_"))) {
                LoopTaskUtils.reloadLoopContext(context, instruction.getState(context).getName());
                totalInstances = loopContextHolder.getNrOfInstances().get() - loopContextHolder.getNrOfCompletedInstances().get();
            } else {
                LoopTaskUtils.createLoopCounterContext(context);
                totalInstances = loopContextHolder.getNrOfInstances().get();
            }
            maxInstances = Math.min(loop.getParallel(), totalInstances);
            semaphore = new Semaphore(maxInstances);
            context.setVariable("loopSemaphore", semaphore);
            context.setVariable("_is_loop_state_", true);
            for (int i = 0; i < totalInstances; ++i) {
                try {
                    ProcessContextImpl tempContext;
                    semaphore.acquire();
                    if (!loopContextHolder.getForwardCounterStack().isEmpty()) {
                        int failEndLoopCounter = loopContextHolder.getForwardCounterStack().pop();
                        tempContext = (ProcessContextImpl)LoopTaskUtils.createLoopEventContext(context, failEndLoopCounter);
                    } else {
                        if (loopContextHolder.isFailEnd() || LoopTaskUtils.isCompletionConditionSatisfied(context)) {
                            semaphore.release();
                            break;
                        }
                        tempContext = (ProcessContextImpl)LoopTaskUtils.createLoopEventContext(context, -1);
                    }
                    if ("forward".equals(context.getVariable("_operation_name_"))) {
                        ((HierarchicalProcessContext)context).setVariableLocally("_is_for_sub_statemachine_forward_", LoopTaskUtils.isForSubStateMachineForward(tempContext));
                    }
                    stateMachineConfig.getAsyncProcessCtrlEventPublisher().publish(tempContext);
                    loopContextHolder.getNrOfActiveInstances().incrementAndGet();
                    loopContextList.add(tempContext);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("try execute loop task for State: [{}] is interrupted, message: [{}]", (Object)instruction.getStateName(), (Object)e.getMessage());
                    throw new EngineExecutionException(e);
                }
            }
        } else {
            LOGGER.warn("Loop config of State [{}] is illegal, will execute as normal", (Object)instruction.getStateName());
            instruction.setTemporaryState(instruction.getState(context));
        }
        try {
            if (null != semaphore) {
                boolean isFinished = false;
                while (!isFinished) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("wait {}ms for loop state [{}] finish", (Object)1000, (Object)instruction.getStateName());
                    }
                    isFinished = semaphore.tryAcquire(maxInstances, 1000L, TimeUnit.MILLISECONDS);
                }
                if (loopContextList.size() > 0) {
                    LoopTaskUtils.putContextToParent(context, loopContextList, instruction.getState(context));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("State: [{}] wait loop execution complete is interrupted, message: [{}]", (Object)instruction.getStateName(), (Object)e.getMessage());
            throw new EngineExecutionException(e);
        }
        finally {
            context.removeVariable("loopSemaphore");
            context.removeVariable("_is_loop_state_");
            LoopContextHolder.clearCurrent(context);
        }
        if (loopContextHolder.isFailEnd()) {
            String currentExceptionRoute = LoopTaskUtils.decideCurrentExceptionRoute(loopContextList, stateMachineInstance.getStateMachine());
            if (StringUtils.isNotBlank(currentExceptionRoute)) {
                ((HierarchicalProcessContext)context).setVariableLocally("_current_exception_route_", currentExceptionRoute);
            } else {
                for (ProcessContext processContext : loopContextList) {
                    if (!processContext.hasVariable("currentException")) continue;
                    Exception exception = (Exception)processContext.getVariable("currentException");
                    EngineUtils.failStateMachine(context, exception);
                    break;
                }
            }
        }
    }
}

