/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.pcext.InterceptableStateRouter;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.StateRouter;
import org.apache.seata.saga.engine.pcext.StateRouterInterceptor;
import org.apache.seata.saga.engine.pcext.routers.EndStateRouter;
import org.apache.seata.saga.engine.pcext.routers.TaskStateRouter;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.proctrl.Instruction;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.ProcessRouter;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateMachine;
import org.apache.seata.saga.statelang.domain.StateType;

public class StateMachineProcessRouter
implements ProcessRouter {
    private final Map<StateType, StateRouter> stateRouters = new ConcurrentHashMap<StateType, StateRouter>();

    @Override
    public Instruction route(ProcessContext context) throws FrameworkException {
        State state;
        StateInstruction stateInstruction = context.getInstruction(StateInstruction.class);
        if (stateInstruction.getTemporaryState() != null) {
            state = stateInstruction.getTemporaryState();
            stateInstruction.setTemporaryState(null);
        } else {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            StateMachine stateMachine = stateMachineConfig.getStateMachineRepository().getStateMachine(stateInstruction.getStateMachineName(), stateInstruction.getTenantId());
            state = stateMachine.getStates().get(stateInstruction.getStateName());
        }
        StateType stateType = state.getType();
        StateRouter router = this.stateRouters.get((Object)stateType);
        Instruction instruction = null;
        List<StateRouterInterceptor> interceptors = null;
        if (router instanceof InterceptableStateRouter) {
            interceptors = ((InterceptableStateRouter)router).getInterceptors();
        }
        ArrayList<StateRouterInterceptor> executedInterceptors = null;
        Exception exception = null;
        try {
            if (CollectionUtils.isNotEmpty(interceptors)) {
                executedInterceptors = new ArrayList<StateRouterInterceptor>(interceptors.size());
                for (StateRouterInterceptor interceptor : interceptors) {
                    executedInterceptors.add(interceptor);
                    interceptor.preRoute(context, state);
                }
            }
            instruction = router.route(context, state);
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            if (CollectionUtils.isNotEmpty(executedInterceptors)) {
                for (int i = executedInterceptors.size() - 1; i >= 0; --i) {
                    StateRouterInterceptor interceptor = (StateRouterInterceptor)executedInterceptors.get(i);
                    interceptor.postRoute(context, state, instruction, exception);
                }
            }
            if (instruction == null && !stateInstruction.isEnd()) {
                EngineUtils.endStateMachine(context);
            }
        }
        return instruction;
    }

    public void initDefaultStateRouters() {
        if (!this.stateRouters.isEmpty()) {
            return;
        }
        TaskStateRouter taskStateRouter = new TaskStateRouter();
        this.stateRouters.put(StateType.SERVICE_TASK, taskStateRouter);
        this.stateRouters.put(StateType.SCRIPT_TASK, taskStateRouter);
        this.stateRouters.put(StateType.CHOICE, taskStateRouter);
        this.stateRouters.put(StateType.COMPENSATION_TRIGGER, taskStateRouter);
        this.stateRouters.put(StateType.SUB_STATE_MACHINE, taskStateRouter);
        this.stateRouters.put(StateType.SUB_MACHINE_COMPENSATION, taskStateRouter);
        this.stateRouters.put(StateType.LOOP_START, taskStateRouter);
        this.stateRouters.put(StateType.SUCCEED, new EndStateRouter());
        this.stateRouters.put(StateType.FAIL, new EndStateRouter());
    }

    public Map<StateType, StateRouter> getStateRouters() {
        return this.stateRouters;
    }

    public void setStateRouters(Map<StateType, StateRouter> stateRouters) {
        this.stateRouters.putAll(stateRouters);
    }
}

