/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.integration.tx.api.fence.config.CommonFenceConfig;
import org.apache.seata.integration.tx.api.interceptor.ActionInterceptorHandler;
import org.apache.seata.integration.tx.api.interceptor.InvocationHandlerType;
import org.apache.seata.integration.tx.api.interceptor.InvocationWrapper;
import org.apache.seata.integration.tx.api.interceptor.SeataInterceptorPosition;
import org.apache.seata.integration.tx.api.interceptor.TwoPhaseBusinessActionParam;
import org.apache.seata.integration.tx.api.interceptor.handler.AbstractProxyInvocationHandler;
import org.apache.seata.rm.tcc.api.TwoPhaseBusinessAction;
import org.apache.seata.rm.tcc.utils.MethodUtils;
import org.slf4j.MDC;
import org.springframework.transaction.annotation.Transactional;

public class TccActionInterceptorHandler
extends AbstractProxyInvocationHandler {
    private static final int ORDER_NUM = ConfigurationFactory.getInstance().getInt("client.rm.tccActionInterceptorOrder", -2147482648);
    protected ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();
    private Set<String> methodsToProxy;
    protected Object targetBean;
    protected Map<Method, Annotation> parseAnnotationCache = new ConcurrentHashMap<Method, Annotation>();

    public TccActionInterceptorHandler(Object targetBean, Set<String> methodsToProxy) {
        this.targetBean = targetBean;
        this.methodsToProxy = methodsToProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInvoke(InvocationWrapper invocation) throws Throwable {
        if (!RootContext.inGlobalTransaction() || RootContext.inSagaBranch()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        Annotation businessAction = this.parseAnnotation(method);
        if (businessAction != null) {
            String xid = RootContext.getXID();
            BranchType previousBranchType = RootContext.getBranchType();
            if (this.getBranchType() != previousBranchType) {
                RootContext.bindBranchType(this.getBranchType());
            }
            try {
                TwoPhaseBusinessActionParam businessActionParam = this.createTwoPhaseBusinessActionParam(businessAction);
                this.initTransactionalAnnotationContext(method, this.targetBean, businessActionParam.getBusinessActionContext());
                Object object = this.actionInterceptorHandler.proceed(method, invocation.getArguments(), xid, businessActionParam, invocation::proceed);
                return object;
            }
            finally {
                if (this.getBranchType() != previousBranchType) {
                    RootContext.unbindBranchType();
                }
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
        return invocation.proceed();
    }

    private void initTransactionalAnnotationContext(Method method, Object targetBean, Map<String, Object> businessActionContext) {
        Transactional transactionalAnnotation = MethodUtils.getTransactionalAnnotationByMethod(method, targetBean);
        if (transactionalAnnotation != null) {
            businessActionContext.put("isolation", transactionalAnnotation.isolation().value());
        }
    }

    private Annotation parseAnnotation(Method methodKey) throws NoSuchMethodException {
        Annotation result = this.parseAnnotationCache.computeIfAbsent(methodKey, method -> {
            Set<Class<?>> interfaceClasses;
            Annotation twoPhaseBusinessAction = method.getAnnotation(this.getAnnotationClass());
            if (twoPhaseBusinessAction == null && this.targetBean.getClass() != null && (interfaceClasses = ReflectionUtil.getInterfaces(this.targetBean.getClass())) != null) {
                NoSuchMethodException exception = null;
                for (Class<?> interClass : interfaceClasses) {
                    try {
                        Method m = interClass.getMethod(method.getName(), method.getParameterTypes());
                        twoPhaseBusinessAction = m.getAnnotation(this.getAnnotationClass());
                        if (twoPhaseBusinessAction == null) continue;
                        this.initCommonFenceCleanTask(twoPhaseBusinessAction);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        exception = e;
                    }
                }
                if (twoPhaseBusinessAction == null && exception != null) {
                    throw new RuntimeException(exception);
                }
            }
            return twoPhaseBusinessAction;
        });
        return result;
    }

    protected TwoPhaseBusinessActionParam createTwoPhaseBusinessActionParam(Annotation annotation) {
        TwoPhaseBusinessAction businessAction = (TwoPhaseBusinessAction)annotation;
        TwoPhaseBusinessActionParam businessActionParam = new TwoPhaseBusinessActionParam();
        businessActionParam.setActionName(businessAction.name());
        businessActionParam.setDelayReport(businessAction.isDelayReport());
        businessActionParam.setUseCommonFence(businessAction.useTCCFence());
        businessActionParam.setBranchType(this.getBranchType());
        HashMap<String, Object> businessActionContextMap = new HashMap<String, Object>(4);
        businessActionContextMap.put("sys::commit", businessAction.commitMethod());
        businessActionContextMap.put("sys::rollback", businessAction.rollbackMethod());
        businessActionContextMap.put("actionName", businessAction.name());
        businessActionContextMap.put("useTCCFence", businessAction.useTCCFence());
        businessActionParam.setBusinessActionContext(businessActionContextMap);
        return businessActionParam;
    }

    protected boolean parserCommonFenceConfig(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        TwoPhaseBusinessAction businessAction = (TwoPhaseBusinessAction)annotation;
        return businessAction.useTCCFence();
    }

    protected BranchType getBranchType() {
        return BranchType.TCC;
    }

    protected Class<? extends Annotation> getAnnotationClass() {
        return TwoPhaseBusinessAction.class;
    }

    private void initCommonFenceCleanTask(Annotation twoPhaseBusinessAction) {
        CommonFenceConfig commonFenceConfig = (CommonFenceConfig)ObjectHolder.INSTANCE.getObject("SpringFenceConfig");
        if (commonFenceConfig == null || commonFenceConfig.getInitialized().get()) {
            return;
        }
        if (twoPhaseBusinessAction != null && this.parserCommonFenceConfig(twoPhaseBusinessAction) && commonFenceConfig.getInitialized().compareAndSet(false, true)) {
            commonFenceConfig.init();
        }
    }

    @Override
    public Set<String> getMethodsToProxy() {
        return this.methodsToProxy;
    }

    @Override
    public int getOrder() {
        return ORDER_NUM;
    }

    @Override
    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.Any;
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public String type() {
        return InvocationHandlerType.TwoPhaseAnnotation.name();
    }
}

