/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.fence;

import javax.sql.DataSource;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.integration.tx.api.fence.config.CommonFenceConfig;
import org.apache.seata.integration.tx.api.fence.exception.CommonFenceException;
import org.apache.seata.rm.fence.SpringFenceHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringFenceConfig
extends CommonFenceConfig
implements InitializingBean {
    private final DataSource dataSource;
    private final PlatformTransactionManager transactionManager;

    public SpringFenceConfig(DataSource dataSource, PlatformTransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.transactionManager = transactionManager;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new CommonFenceException(FrameworkErrorCode.DateSourceNeedInjected);
        }
        SpringFenceHandler.setDataSource(this.dataSource);
        if (this.transactionManager == null) {
            throw new CommonFenceException(FrameworkErrorCode.TransactionManagerNeedInjected);
        }
        SpringFenceHandler.setTransactionTemplate(new TransactionTemplate(this.transactionManager));
    }
}

