/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.rm.datasource.util.JdbcUtils;
import org.apache.seata.rm.datasource.xa.AbstractDataSourceProxyXA;
import org.apache.seata.rm.datasource.xa.ConnectionProxyXA;

public class DataSourceProxyXANative
extends AbstractDataSourceProxyXA {
    private XADataSource xaDataSource;

    public DataSourceProxyXANative(XADataSource dataSource) {
        this(dataSource, "DEFAULT_XA");
    }

    public DataSourceProxyXANative(XADataSource dataSource, String resourceGroupId) {
        if (dataSource instanceof DataSource) {
            this.dataSource = (DataSource)((Object)dataSource);
        }
        this.xaDataSource = dataSource;
        this.branchType = BranchType.XA;
        JdbcUtils.initXADataSourceResource(this, dataSource, resourceGroupId);
    }

    @Override
    public Connection getConnection() throws SQLException {
        XAConnection xaConnection = this.xaDataSource.getXAConnection();
        return this.getConnectionProxy(xaConnection);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        XAConnection xaConnection = this.xaDataSource.getXAConnection(username, password);
        return this.getConnectionProxy(xaConnection);
    }

    protected Connection getConnectionProxy(XAConnection xaConnection) throws SQLException {
        Connection connection = xaConnection.getConnection();
        ConnectionProxyXA connectionProxyXA = new ConnectionProxyXA(connection, xaConnection, this, RootContext.getXID());
        connectionProxyXA.init();
        return connectionProxyXA;
    }

    @Override
    protected Connection getConnectionProxyXA() throws SQLException {
        return this.getConnection();
    }
}

