/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.oscar;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.DateUtil;
import org.apache.seata.core.compressor.CompressorType;
import org.apache.seata.rm.datasource.undo.AbstractUndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="oscar")
public class OscarUndoLogManager
extends AbstractUndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscarUndoLogManager.class);
    private static final String CHECK_UNDO_LOG_TABLE_EXIST_SQL = "SELECT 1 FROM " + UNDO_LOG_TABLE_NAME + " WHERE ROWNUM = 1";
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + " (" + "id" + "," + "branch_id" + ", " + "xid" + ", " + "context" + ", " + "rollback_info" + ", " + "log_status" + ", " + "log_created" + ", " + "log_modified" + ")VALUES (UNDO_LOG_SEQ.nextval, ?, ?, ?, ?, ?, sysdate, sysdate)";
    private static final String DELETE_UNDO_LOG_BY_CREATE_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE " + "log_created" + " <= to_date(?,'yyyy-mm-dd hh24:mi:ss') and ROWNUM <= ?";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteUndoLogByLogCreated(Date logCreated, int limitRows, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_BY_CREATE_SQL);){
            String dateStr = DateUtil.formatDate(logCreated, "yyyy-MM-dd HH:mm:ss");
            deletePST.setString(1, dateStr);
            deletePST.setInt(2, limitRows);
            int deleteRows = deletePST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete undo log size {}", (Object)deleteRows);
            }
            int n = deleteRows;
            return n;
        }
        catch (Exception e2222) {
            if (e2222 instanceof SQLException) throw (SQLException)e2222;
            SQLException e2222 = new SQLException(e2222);
            throw (SQLException)e2222;
        }
    }

    @Override
    protected void insertUndoLogWithNormal(String xid, long branchId, String rollbackCtx, byte[] undoLogContent, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, rollbackCtx, undoLogContent, AbstractUndoLogManager.State.Normal, conn);
    }

    @Override
    protected void insertUndoLogWithGlobalFinished(String xid, long branchId, UndoLogParser parser, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, this.buildContext(parser.getName(), CompressorType.NONE, new String[0]), parser.getDefaultContent(), AbstractUndoLogManager.State.GlobalFinished, conn);
    }

    private void insertUndoLog(String xid, long branchID, String rollbackCtx, byte[] undoLogContent, AbstractUndoLogManager.State state, Connection conn) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(INSERT_UNDO_LOG_SQL);){
            pst.setLong(1, branchID);
            pst.setString(2, xid);
            pst.setString(3, rollbackCtx);
            pst.setBytes(4, undoLogContent);
            pst.setInt(5, state.getValue());
            pst.executeUpdate();
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }

    @Override
    protected String getCheckUndoLogTableExistSql() {
        return CHECK_UNDO_LOG_TABLE_EXIST_SQL;
    }
}

