/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec.sqlserver;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.MultiDeleteExecutor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.sqlparser.SQLDeleteRecognizer;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class SqlServerMultiDeleteExecutor<T, S extends Statement>
extends MultiDeleteExecutor<T, S> {
    public SqlServerMultiDeleteExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        StringBuilder whereCondition = new StringBuilder();
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLDeleteRecognizer visitor = (SQLDeleteRecognizer)recognizer;
            if (StringUtils.isNotBlank(visitor.getLimitCondition())) {
                throw new NotSupportYetException("Multi delete SQL with limit condition is not support yet !");
            }
            if (StringUtils.isNotBlank(visitor.getOrderByCondition())) {
                throw new NotSupportYetException("Multi delete SQL with orderBy condition is not support yet !");
            }
            String whereConditionStr = this.buildWhereCondition(visitor, paramAppenderList);
            if (StringUtils.isBlank(whereConditionStr)) {
                whereCondition = new StringBuilder();
                paramAppenderList.clear();
                break;
            }
            if (whereCondition.length() > 0 && this.sqlRecognizers.size() > 1) {
                whereCondition.append(" OR ");
            }
            whereCondition.append(whereConditionStr);
        }
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL()).append(" WITH(UPDLOCK) ");
        if (whereCondition.length() > 0) {
            suffix.append(" WHERE ").append((CharSequence)whereCondition);
        }
        StringJoiner selectSQLAppender = new StringJoiner(", ", "SELECT ", suffix.toString());
        for (String column : tmeta.getAllColumns().keySet()) {
            selectSQLAppender.add(this.getColumnNameInSQL(ColumnUtils.addEscape(column, this.getDbType())));
        }
        return this.buildTableRecords(tmeta, selectSQLAppender.toString(), paramAppenderList);
    }
}

