/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec.oscar;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.BaseInsertExecutor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.sqlparser.SQLInsertRecognizer;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.struct.Null;
import org.apache.seata.sqlparser.struct.Sequenceable;
import org.apache.seata.sqlparser.struct.SqlMethodExpr;
import org.apache.seata.sqlparser.struct.SqlSequenceExpr;
import org.apache.seata.sqlparser.util.ColumnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="oscar", scope=Scope.PROTOTYPE)
public class OscarInsertExecutor
extends BaseInsertExecutor
implements Sequenceable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscarInsertExecutor.class);

    public OscarInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        HashMap<String, List<Object>> pkValuesMap = new HashMap<String, List<Object>>(pkColumnNameList.size());
        if (!this.containsColumns() || this.containsAnyPk()) {
            pkValuesMap.putAll(this.getPkValuesByColumn());
        }
        for (String columnName : pkColumnNameList) {
            if (pkValuesMap.containsKey(columnName)) continue;
            pkValuesMap.put(columnName, this.getGeneratedKeys(columnName));
        }
        return pkValuesMap;
    }

    public boolean containsAnyPk() {
        SQLInsertRecognizer recognizer = (SQLInsertRecognizer)this.sqlRecognizer;
        List<String> insertColumns = recognizer.getInsertColumns();
        if (CollectionUtils.isEmpty(insertColumns)) {
            return false;
        }
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        if (CollectionUtils.isEmpty(pkColumnNameList)) {
            return false;
        }
        List<String> newColumns = ColumnUtils.delEscape(insertColumns, this.getDbType());
        return pkColumnNameList.stream().anyMatch(pkColumn -> newColumns.contains(pkColumn) || CollectionUtils.toUpperList(newColumns).contains(pkColumn.toUpperCase()));
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        Set<String> keySet = pkValuesMap.keySet();
        for (String pkKey : keySet) {
            List<Object> pkValues = pkValuesMap.get(pkKey);
            for (int i = 0; i < pkValues.size(); ++i) {
                if (!pkKey.isEmpty() && pkValues.get(i) instanceof SqlSequenceExpr) {
                    pkValues.set(i, this.getPkValuesBySequence((SqlSequenceExpr)pkValues.get(i), pkKey).get(0));
                    continue;
                }
                if (!pkKey.isEmpty() && pkValues.get(i) instanceof SqlMethodExpr) {
                    pkValues.set(i, this.getGeneratedKeys(pkKey).get(0));
                    continue;
                }
                if (pkKey.isEmpty() || !(pkValues.get(i) instanceof Null)) continue;
                pkValues.set(i, this.getGeneratedKeys(pkKey).get(0));
            }
            pkValuesMap.put(pkKey, pkValues);
        }
        return pkValuesMap;
    }

    @Override
    public String getSequenceSql(SqlSequenceExpr expr) {
        return "SELECT " + expr.getSequence() + ".currval FROM DUAL";
    }
}

