/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.rm.datasource.SqlGenerateUtils;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.exec.UpdateExecutor;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLUpdateRecognizer;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class MultiUpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = CONFIG.getBoolean("client.undo.onlyCareUpdateColumns", true);

    public MultiUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        if (this.sqlRecognizers.size() == 1) {
            UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
            return executor.beforeImage();
        }
        TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        HashSet<String> updateColumnsSet = new HashSet<String>();
        StringBuilder whereCondition = new StringBuilder();
        boolean noWhereCondition = false;
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)recognizer;
            if (StringUtils.isNotBlank(sqlUpdateRecognizer.getLimitCondition())) {
                throw new NotSupportYetException("Multi update SQL with limit condition is not support yet !");
            }
            if (StringUtils.isNotBlank(sqlUpdateRecognizer.getOrderByCondition())) {
                throw new NotSupportYetException("Multi update SQL with orderBy condition is not support yet !");
            }
            List<String> updateColumns = sqlUpdateRecognizer.getUpdateColumnsUnEscape();
            updateColumnsSet.addAll(updateColumns);
            if (noWhereCondition) continue;
            String whereConditionStr = this.buildWhereCondition(sqlUpdateRecognizer, paramAppenderList);
            if (StringUtils.isBlank(whereConditionStr)) {
                noWhereCondition = true;
                continue;
            }
            if (whereCondition.length() > 0) {
                whereCondition.append(" OR ");
            }
            whereCondition.append(whereConditionStr);
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        if (noWhereCondition) {
            paramAppenderList.clear();
            whereCondition = new StringBuilder();
        }
        StringJoiner selectSQLAppender = new StringJoiner(", ", prefix, this.buildSuffixSql(whereCondition.toString()));
        List<String> needColumns = this.getNeedColumns(tmeta.getTableName(), this.sqlRecognizer.getTableAlias(), new ArrayList<String>(updateColumnsSet));
        needColumns.forEach(selectSQLAppender::add);
        return this.buildTableRecords(tmeta, selectSQLAppender.toString(), paramAppenderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableRecords tableRecords;
        if (this.sqlRecognizers.size() == 1) {
            UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
            return executor.afterImage(beforeImage);
        }
        if (beforeImage == null || beforeImage.size() == 0) {
            return TableRecords.empty(this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName()));
        }
        TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
        String selectSQL = this.buildAfterImageSQL(tmeta, beforeImage);
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
            SqlGenerateUtils.setParamForPk(beforeImage.pkRows(), this.getTableMeta().getPrimaryKeyOnlyName(), pst);
            rs = pst.executeQuery();
            tableRecords = TableRecords.buildRecords(tmeta, rs);
        }
        catch (Throwable throwable) {
            IOUtil.close(rs, pst);
            throw throwable;
        }
        IOUtil.close(rs, pst);
        return tableRecords;
    }

    private String buildAfterImageSQL(TableMeta tableMeta, TableRecords beforeImage) throws SQLException {
        HashSet<String> updateColumnsSet = new HashSet<String>();
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
            updateColumnsSet.addAll(sqlUpdateRecognizer.getUpdateColumnsUnEscape());
        }
        StringJoiner selectSQLJoiner = new StringJoiner(", ", "SELECT ", " FROM " + this.getFromTableInSQL() + " WHERE ");
        if (ONLY_CARE_UPDATE_COLUMNS) {
            if (!this.containsPK(new ArrayList<String>(updateColumnsSet))) {
                selectSQLJoiner.add(this.getColumnNamesInSQL(tableMeta.getEscapePkNameList(this.getDbType())));
            }
            for (String updateCol : updateColumnsSet) {
                selectSQLJoiner.add(updateCol);
            }
        } else {
            for (String columnName : tableMeta.getAllColumns().keySet()) {
                selectSQLJoiner.add(ColumnUtils.addEscape(columnName, this.getDbType()));
            }
        }
        return SqlGenerateUtils.buildSQLByPKs(selectSQLJoiner.toString(), "", tableMeta.getPrimaryKeyOnlyName(), beforeImage.pkRows().size(), this.getDbType());
    }

    protected String buildSuffixSql(String whereCondition) {
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        if (StringUtils.isNotBlank(whereCondition)) {
            suffix.append(" WHERE ").append(whereCondition);
        }
        return suffix.append(" FOR UPDATE").toString();
    }
}

