/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.SqlGenerateUtils;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.Executor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.sqlparser.ParametersHolder;
import org.apache.seata.sqlparser.SQLInsertRecognizer;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLType;
import org.apache.seata.sqlparser.WhereRecognizer;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.apache.seata.sqlparser.util.ColumnUtils;

public abstract class BaseTransactionalExecutor<T, S extends Statement>
implements Executor<T> {
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = ConfigurationFactory.getInstance().getBoolean("client.undo.onlyCareUpdateColumns", true);
    protected StatementProxy<S> statementProxy;
    protected StatementCallback<T, S> statementCallback;
    protected SQLRecognizer sqlRecognizer;
    protected List<SQLRecognizer> sqlRecognizers;
    private TableMeta tableMeta;

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizer = sqlRecognizer;
    }

    public BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizers = sqlRecognizers;
    }

    @Override
    public T execute(Object ... args) throws Throwable {
        String xid = RootContext.getXID();
        if (xid != null) {
            this.statementProxy.getConnectionProxy().bind(xid);
        }
        this.statementProxy.getConnectionProxy().setGlobalLockRequire(RootContext.requireGlobalLock());
        return this.doExecute(args);
    }

    protected abstract T doExecute(Object ... var1) throws Throwable;

    protected String buildWhereCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String whereCondition = null;
        whereCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getWhereCondition((ParametersHolder)((Object)this.statementProxy), paramAppenderList) : recognizer.getWhereCondition();
        if (StringUtils.isNotBlank(whereCondition) && CollectionUtils.isNotEmpty(paramAppenderList) && paramAppenderList.size() > 1) {
            StringBuilder whereConditionSb = new StringBuilder();
            whereConditionSb.append(" ( ").append(whereCondition).append(" ) ");
            for (int i = 1; i < paramAppenderList.size(); ++i) {
                whereConditionSb.append(" or ( ").append(whereCondition).append(" ) ");
            }
            whereCondition = whereConditionSb.toString();
        }
        return whereCondition;
    }

    protected String buildOrderCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String orderByCondition = null;
        orderByCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getOrderByCondition((ParametersHolder)((Object)this.statementProxy), paramAppenderList) : recognizer.getOrderByCondition();
        return orderByCondition;
    }

    protected String buildLimitCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String limitCondition = null;
        limitCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getLimitCondition((ParametersHolder)((Object)this.statementProxy), paramAppenderList) : recognizer.getLimitCondition();
        return limitCondition;
    }

    protected String getColumnNameWithTablePrefix(String table, String tableAlias, String columnName) {
        return tableAlias == null ? (table == null ? columnName : table + "." + columnName) : tableAlias + "." + columnName;
    }

    protected List<String> getColumnNamesWithTablePrefixList(String table, String tableAlias, List<String> columnNames) {
        ArrayList<String> columnNameWithTablePrefix = new ArrayList<String>();
        for (String columnName : columnNames) {
            columnNameWithTablePrefix.add(this.getColumnNameWithTablePrefix(table, tableAlias, columnName));
        }
        return columnNameWithTablePrefix;
    }

    protected String getColumnNamesWithTablePrefix(String table, String tableAlias, List<String> columnNameList) {
        if (CollectionUtils.isEmpty(columnNameList)) {
            return null;
        }
        StringBuilder columnNamesStr = new StringBuilder();
        for (int i = 0; i < columnNameList.size(); ++i) {
            if (i > 0) {
                columnNamesStr.append(" , ");
            }
            columnNamesStr.append(this.getColumnNameWithTablePrefix(table, tableAlias, columnNameList.get(i)));
        }
        return columnNamesStr.toString();
    }

    protected String getColumnNameInSQL(String columnName) {
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? columnName : tableAlias + "." + columnName;
    }

    protected List<String> getColumnNamesInSQLList(List<String> columnNames) {
        ArrayList<String> columnNameWithTableAlias = new ArrayList<String>();
        for (String columnName : columnNames) {
            columnNameWithTableAlias.add(this.getColumnNameInSQL(columnName));
        }
        return columnNameWithTableAlias;
    }

    protected String getColumnNamesInSQL(List<String> columnNameList) {
        if (CollectionUtils.isEmpty(columnNameList)) {
            return null;
        }
        StringBuilder columnNamesStr = new StringBuilder();
        for (int i = 0; i < columnNameList.size(); ++i) {
            if (i > 0) {
                columnNamesStr.append(" , ");
            }
            columnNamesStr.append(this.getColumnNameInSQL(columnNameList.get(i)));
        }
        return columnNamesStr.toString();
    }

    protected String getFromTableInSQL() {
        String tableName = this.sqlRecognizer.getTableName();
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? tableName : tableName + " " + tableAlias;
    }

    protected TableMeta getTableMeta() {
        return this.getTableMeta(this.sqlRecognizer.getTableName());
    }

    protected TableMeta getTableMeta(String tableName) {
        if (this.tableMeta != null) {
            return this.tableMeta;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        this.tableMeta = TableMetaCacheFactory.getTableMetaCache(connectionProxy.getDbType()).getTableMeta(connectionProxy.getTargetConnection(), tableName, connectionProxy.getDataSourceProxy().getResourceId());
        return this.tableMeta;
    }

    protected boolean containsPK(List<String> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        List<String> newColumns = ColumnUtils.delEscape(columns, this.getDbType());
        return this.getTableMeta().containsPK(newColumns);
    }

    protected boolean containsPK(String tableName, List<String> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        List<String> newColumns = ColumnUtils.delEscape(columns, this.getDbType());
        return this.getTableMeta(tableName).containsPK(newColumns);
    }

    protected boolean containPK(String columnName) {
        String newColumnName = ColumnUtils.delEscape(columnName, this.getDbType());
        return CollectionUtils.toUpperList(this.getTableMeta().getPrimaryKeyOnlyName()).contains(newColumnName.toUpperCase());
    }

    protected String getStandardPkColumnName(String userColumnName) {
        String newUserColumnName = ColumnUtils.delEscape(userColumnName, this.getDbType());
        for (String cn : this.getTableMeta().getPrimaryKeyOnlyName()) {
            if (!cn.equalsIgnoreCase(newUserColumnName)) continue;
            return cn;
        }
        return null;
    }

    protected void prepareUndoLog(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (beforeImage.getRows().isEmpty() && afterImage.getRows().isEmpty()) {
            return;
        }
        if (SQLType.UPDATE == this.sqlRecognizer.getSQLType() && beforeImage.getRows().size() != afterImage.getRows().size()) {
            throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        TableRecords lockKeyRecords = this.sqlRecognizer.getSQLType() == SQLType.DELETE ? beforeImage : afterImage;
        String lockKeys = this.buildLockKey(lockKeyRecords);
        if (null != lockKeys) {
            connectionProxy.appendLockKey(lockKeys);
            SQLUndoLog sqlUndoLog = this.buildUndoItem(beforeImage, afterImage);
            connectionProxy.appendUndoLog(sqlUndoLog);
        }
    }

    protected void validPk(String pkVal) {
        if (pkVal.contains(",")) {
            throw new IllegalArgumentException(pkVal + " contains illegal character!");
        }
    }

    protected String buildLockKey(TableRecords rowsIncludingPK) {
        if (rowsIncludingPK.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rowsIncludingPK.getTableMeta().getTableName());
        sb.append(":");
        int rowSequence = 0;
        List<Map<String, Field>> pksRows = rowsIncludingPK.pkRows();
        List<String> primaryKeysOnlyName = rowsIncludingPK.getTableMeta().getPrimaryKeyOnlyName();
        for (Map<String, Field> rowMap : pksRows) {
            int pkSplitIndex = 0;
            for (String pkName : primaryKeysOnlyName) {
                if (pkSplitIndex > 0) {
                    sb.append("_");
                }
                Object pkVal = rowMap.get(pkName).getValue();
                this.validPk(String.valueOf(pkVal));
                sb.append(pkVal);
                ++pkSplitIndex;
            }
            if (++rowSequence >= pksRows.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected SQLUndoLog buildUndoItem(TableRecords beforeImage, TableRecords afterImage) {
        SQLType sqlType = this.sqlRecognizer.getSQLType();
        String tableName = this.sqlRecognizer.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords buildTableRecords(TableMeta tableMeta, String selectSQL, ArrayList<List<Object>> paramAppenderList) throws SQLException {
        TableRecords tableRecords;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.statementProxy.getConnection().prepareStatement(selectSQL);
            if (CollectionUtils.isNotEmpty(paramAppenderList)) {
                int ts = paramAppenderList.size();
                for (int i = 0; i < ts; ++i) {
                    List<Object> paramAppender = paramAppenderList.get(i);
                    int ds = paramAppender.size();
                    for (int j = 0; j < ds; ++j) {
                        ps.setObject(i * ds + j + 1, paramAppender.get(j));
                    }
                }
            }
            rs = ps.executeQuery();
            tableRecords = TableRecords.buildRecords(tableMeta, rs);
        }
        catch (Throwable throwable) {
            IOUtil.close(rs, ps);
            throw throwable;
        }
        IOUtil.close(rs, ps);
        return tableRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords buildTableRecords(Map<String, List<Object>> pkValuesMap) throws SQLException {
        TableRecords tableRecords;
        SQLInsertRecognizer recognizer = (SQLInsertRecognizer)this.sqlRecognizer;
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        String prefix = "SELECT ";
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        String firstKey = (String)pkValuesMap.keySet().stream().findFirst().get();
        int rowSize = pkValuesMap.get(firstKey).size();
        suffix.append(" WHERE ");
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix, suffix.toString());
        List<String> insertColumnsUnEscape = recognizer.getInsertColumnsUnEscape();
        List<String> needColumns = this.getNeedColumns(this.tableMeta.getTableName(), this.sqlRecognizer.getTableAlias(), insertColumnsUnEscape);
        needColumns.forEach(selectSQLJoin::add);
        PreparedStatement ps = null;
        String sqlStr = SqlGenerateUtils.buildSQLByPKs(selectSQLJoin.toString(), "", pkColumnNameList, rowSize, this.getDbType());
        ResultSet rs = null;
        try {
            ps = this.statementProxy.getConnection().prepareStatement(sqlStr);
            int paramIndex = 1;
            for (int r = 0; r < rowSize; ++r) {
                for (int c = 0; c < pkColumnNameList.size(); ++c) {
                    List<Object> pkColumnValueList = pkValuesMap.get(pkColumnNameList.get(c));
                    int dataType = this.tableMeta.getColumnMeta(pkColumnNameList.get(c)).getDataType();
                    ps.setObject(paramIndex, pkColumnValueList.get(r), dataType);
                    ++paramIndex;
                }
            }
            rs = ps.executeQuery();
            tableRecords = TableRecords.buildRecords(this.getTableMeta(), rs);
        }
        catch (Throwable throwable) {
            IOUtil.close(rs, ps);
            throw throwable;
        }
        IOUtil.close(rs, ps);
        return tableRecords;
    }

    protected List<String> getNeedColumns(String table, String tableAlias, List<String> unescapeColumns) {
        TreeSet<String> needUpdateColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TableMeta tableMeta = this.getTableMeta(table);
        if (ONLY_CARE_UPDATE_COLUMNS && CollectionUtils.isNotEmpty(unescapeColumns)) {
            List<String> pkNameList;
            if (!this.containsPK(table, unescapeColumns) && CollectionUtils.isNotEmpty(pkNameList = tableMeta.getEscapePkNameList(this.getDbType()))) {
                if (StringUtils.isNotBlank(tableAlias)) {
                    needUpdateColumns.addAll(ColumnUtils.delEscape(this.getColumnNamesWithTablePrefixList(table, tableAlias, pkNameList), this.getDbType()));
                } else {
                    needUpdateColumns.addAll(ColumnUtils.delEscape(this.getColumnNamesInSQLList(pkNameList), this.getDbType()));
                }
            }
            needUpdateColumns.addAll(unescapeColumns);
            List<String> onUpdateColumns = tableMeta.getOnUpdateColumnsOnlyName();
            if (StringUtils.isNotBlank(tableAlias)) {
                onUpdateColumns = onUpdateColumns.stream().map(onUpdateColumn -> this.getColumnNameWithTablePrefix(table, tableAlias, (String)onUpdateColumn)).collect(Collectors.toList());
            }
            needUpdateColumns.addAll(onUpdateColumns);
        } else {
            Stream<Object> allColumns = tableMeta.getAllColumns().keySet().stream();
            if (StringUtils.isNotBlank(tableAlias)) {
                allColumns = allColumns.map(columnName -> this.getColumnNameWithTablePrefix(table, tableAlias, (String)columnName));
            }
            allColumns.forEach(needUpdateColumns::add);
        }
        return needUpdateColumns.stream().map(column -> ColumnUtils.addEscape(column, this.getDbType(), tableMeta)).collect(Collectors.toList());
    }

    protected String getDbType() {
        return this.statementProxy.getConnectionProxy().getDbType();
    }
}

