/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.Resource;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.rm.datasource.AbstractDataSourceProxy;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.SeataDataSourceProxy;
import org.apache.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import org.apache.seata.rm.datasource.undo.UndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogManagerFactory;
import org.apache.seata.rm.datasource.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceProxy.class);
    private static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT";
    private String resourceGroupId;
    private String jdbcUrl;
    private String resourceId;
    private String dbType;
    private String userName;
    private String kernelVersion;
    private String productVersion;
    private final Map<String, String> variables = new HashMap<String, String>();
    private static final String[] POLARDB_X_PRODUCT_KEYWORD = new String[]{"TDDL", "AliSQL-X", "PXC"};

    public DataSourceProxy(DataSource targetDataSource) {
        this(targetDataSource, DEFAULT_RESOURCE_GROUP_ID);
    }

    public DataSourceProxy(DataSource targetDataSource, String resourceGroupId) {
        if (targetDataSource instanceof SeataDataSourceProxy) {
            LOGGER.info("Unwrap the target data source, because the type is: {}", (Object)targetDataSource.getClass().getName());
            targetDataSource = ((SeataDataSourceProxy)targetDataSource).getTargetDataSource();
        }
        this.targetDataSource = targetDataSource;
        this.init(targetDataSource, resourceGroupId);
    }

    private void init(DataSource dataSource, String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType(this.jdbcUrl);
            if ("oracle".equals(this.dbType)) {
                this.userName = connection.getMetaData().getUserName();
            } else if ("mysql".equals(this.dbType)) {
                this.validMySQLVersion(connection);
                this.checkDerivativeProduct();
            }
            this.checkUndoLogTableExist(connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
        if ("sqlserver".equals(this.dbType)) {
            LOGGER.info("SQLServer support in AT mode is currently an experimental function, if you have any problems in use, please feedback to us");
        }
        this.initResourceId();
        DefaultResourceManager.get().registerResource(this);
        TableMetaCacheFactory.registerTableMeta(this);
        RootContext.setDefaultBranchType(this.getBranchType());
    }

    private void checkDerivativeProduct() {
        if (!"mysql".equals(this.dbType)) {
            return;
        }
        if (this.isPolardbXProduct()) {
            this.dbType = "polardb-x";
            return;
        }
    }

    private boolean isPolardbXProduct() {
        if (StringUtils.isBlank((String)this.productVersion)) {
            return false;
        }
        for (String keyword : POLARDB_X_PRODUCT_KEYWORD) {
            if (!this.productVersion.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private void checkUndoLogTableExist(Connection conn) {
        UndoLogManager undoLogManager;
        try {
            undoLogManager = UndoLogManagerFactory.getUndoLogManager(this.dbType);
        }
        catch (EnhancedServiceNotFoundException e) {
            String errMsg = String.format("AT mode don't support the dbtype: %s", this.dbType);
            throw new IllegalStateException(errMsg, (Throwable)((Object)e));
        }
        boolean undoLogTableExist = undoLogManager.hasUndoLogTable(conn);
        if (!undoLogTableExist) {
            String undoLogTableName = ConfigurationFactory.getInstance().getConfig("client.undo.logTable", "undo_log");
            String errMsg = String.format("in AT mode, %s table not exist", undoLogTableName);
            throw new IllegalStateException(errMsg);
        }
    }

    public void tableMetaRefreshEvent() {
        TableMetaCacheFactory.tableMetaRefreshEvent(this.getResourceId());
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    @Override
    public String getResourceId() {
        if (this.resourceId == null) {
            this.initResourceId();
        }
        return this.resourceId;
    }

    private void initResourceId() {
        if ("postgresql".equals(this.dbType)) {
            this.initPGResourceId();
        } else if ("oracle".equals(this.dbType) && this.userName != null) {
            this.initOracleResourceId();
        } else if ("mysql".equals(this.dbType) || "polardb-x".equals(this.dbType)) {
            this.initMysqlResourceId();
        } else if ("sqlserver".equals(this.dbType)) {
            this.initSqlServerResourceId();
        } else if ("dm".equals(this.dbType)) {
            this.initDMResourceId();
        } else if ("oscar".equals(this.dbType)) {
            this.initOscarResourceId();
        } else {
            this.initDefaultResourceId();
        }
    }

    private void initDefaultResourceId() {
        this.resourceId = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) : this.jdbcUrl;
    }

    private void initOracleResourceId() {
        this.resourceId = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) + "/" + this.userName : this.jdbcUrl + "/" + this.userName;
    }

    private void initMysqlResourceId() {
        String startsWith = "jdbc:mysql:loadbalance://";
        if (this.jdbcUrl.startsWith(startsWith)) {
            String url = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) : this.jdbcUrl;
            this.resourceId = url.replace(",", "|");
        } else {
            this.initDefaultResourceId();
        }
    }

    private void initDMResourceId() {
        LOGGER.warn("support for the dameng database is currently an experimental feature ");
        if (this.jdbcUrl.contains("?")) {
            String[] urlParams;
            StringBuilder jdbcUrlBuilder = new StringBuilder();
            jdbcUrlBuilder.append(this.jdbcUrl, 0, this.jdbcUrl.indexOf(63));
            StringBuilder paramsBuilder = new StringBuilder();
            String paramUrl = this.jdbcUrl.substring(this.jdbcUrl.indexOf(63) + 1);
            for (String urlParam : urlParams = paramUrl.split("&")) {
                if (!urlParam.contains("schema")) continue;
                if (urlParam.contains("\"")) {
                    urlParam = urlParam.replaceAll("\"", "");
                }
                paramsBuilder.append(urlParam);
                break;
            }
            if (paramsBuilder.length() > 0) {
                jdbcUrlBuilder.append("?");
                jdbcUrlBuilder.append((CharSequence)paramsBuilder);
            }
            this.resourceId = jdbcUrlBuilder.toString();
        } else {
            this.resourceId = this.jdbcUrl;
        }
    }

    private void initOscarResourceId() {
        this.resourceId = this.jdbcUrl.contains("?") ? this.jdbcUrl.substring(0, this.jdbcUrl.indexOf(63)) + "/" + this.userName : this.jdbcUrl + "/" + this.userName;
    }

    private void initPGResourceId() {
        if (this.jdbcUrl.contains("?")) {
            String[] urlParams;
            StringBuilder jdbcUrlBuilder = new StringBuilder();
            jdbcUrlBuilder.append(this.jdbcUrl, 0, this.jdbcUrl.indexOf(63));
            StringBuilder paramsBuilder = new StringBuilder();
            String paramUrl = this.jdbcUrl.substring(this.jdbcUrl.indexOf(63) + 1);
            for (String urlParam : urlParams = paramUrl.split("&")) {
                if (!urlParam.contains("currentSchema")) continue;
                if (urlParam.contains(",")) {
                    urlParam = urlParam.replace(",", "!");
                }
                paramsBuilder.append(urlParam);
                break;
            }
            if (paramsBuilder.length() > 0) {
                jdbcUrlBuilder.append("?");
                jdbcUrlBuilder.append((CharSequence)paramsBuilder);
            }
            this.resourceId = jdbcUrlBuilder.toString();
        } else {
            this.resourceId = this.jdbcUrl;
        }
        if (this.resourceId.contains(",")) {
            this.resourceId = this.resourceId.replace(",", "|");
        }
    }

    private void initSqlServerResourceId() {
        if (this.jdbcUrl.contains(";")) {
            String[] urlParams;
            StringBuilder jdbcUrlBuilder = new StringBuilder();
            jdbcUrlBuilder.append(this.jdbcUrl, 0, this.jdbcUrl.indexOf(59));
            StringBuilder paramsBuilder = new StringBuilder();
            String paramUrl = this.jdbcUrl.substring(this.jdbcUrl.indexOf(59) + 1);
            for (String urlParam : urlParams = paramUrl.split(";")) {
                String[] paramSplit = urlParam.split("=");
                String propertyName = paramSplit[0];
                if (!"INSTANCENAME".equalsIgnoreCase(propertyName) && !"databaseName".equalsIgnoreCase(propertyName) && !"database".equalsIgnoreCase(propertyName)) continue;
                paramsBuilder.append(urlParam);
            }
            if (paramsBuilder.length() > 0) {
                jdbcUrlBuilder.append(";");
                jdbcUrlBuilder.append((CharSequence)paramsBuilder);
            }
            this.resourceId = jdbcUrlBuilder.toString();
        } else {
            this.resourceId = this.jdbcUrl;
        }
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public String getVariableValue(String name) {
        return this.variables.get(name);
    }

    private void validMySQLVersion(Connection connection) {
        if (!"mysql".equals(this.dbType)) {
            return;
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement("SHOW VARIABLES");
             ResultSet rs = preparedStatement.executeQuery();){
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                if (!StringUtils.isNotBlank((String)name)) continue;
                this.variables.put(name.toLowerCase(), value);
            }
            String version = this.variables.get("version");
            if (StringUtils.isBlank((String)version)) {
                return;
            }
            int dashIdx = version.indexOf(45);
            if (dashIdx > 0) {
                this.kernelVersion = version.substring(0, dashIdx);
                this.productVersion = version.substring(dashIdx + 1);
            } else {
                this.kernelVersion = version;
                this.productVersion = version;
            }
        }
        catch (Exception e) {
            LOGGER.error("check mysql version fail error: {}", (Object)e.getMessage());
        }
    }
}

