/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.util;

import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.seata.common.lock.ResourceLock;
import org.apache.seata.integration.tx.api.interceptor.handler.DefaultInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.DefaultInterfaceParser;

public class ProxyUtil {
    private static final Map<Object, Object> PROXYED_SET = new HashMap<Object, Object>();
    private static final ResourceLock RESOURCE_LOCK = new ResourceLock();

    public static <T> T createProxy(T target) {
        return ProxyUtil.createProxy(target, target.getClass().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T createProxy(T target, String beanName) {
        try (ResourceLock ignored = RESOURCE_LOCK.obtain();){
            if (PROXYED_SET.containsKey(target)) {
                Object object = PROXYED_SET.get(target);
                return (T)object;
            }
            ProxyInvocationHandler proxyInvocationHandler = DefaultInterfaceParser.get().parserInterfaceToProxy(target, beanName);
            if (proxyInvocationHandler == null) {
                T t = target;
                return t;
            }
            Object proxy = new ByteBuddy().subclass(target.getClass()).method((ElementMatcher)ElementMatchers.isDeclaredBy(target.getClass())).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new DefaultInvocationHandler(proxyInvocationHandler, target))).make().load(target.getClass().getClassLoader()).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            PROXYED_SET.put(target, proxy);
            Object t = proxy;
            return t;
        }
        catch (Throwable t) {
            throw new RuntimeException("error occurs when create seata proxy", t);
        }
    }
}

