/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.interceptor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.IfNeedEnhanceBean;
import org.apache.seata.integration.tx.api.interceptor.parser.InterfaceParser;

public class DefaultInterfaceParser
implements InterfaceParser {
    protected static final List<InterfaceParser> ALL_INTERFACE_PARSERS = new ArrayList<InterfaceParser>();

    public static DefaultInterfaceParser get() {
        return SingletonHolder.INSTANCE;
    }

    protected DefaultInterfaceParser() {
        this.initInterfaceParser();
    }

    protected void initInterfaceParser() {
        List<InterfaceParser> interfaceParsers = EnhancedServiceLoader.loadAll(InterfaceParser.class);
        if (CollectionUtils.isNotEmpty(interfaceParsers)) {
            ALL_INTERFACE_PARSERS.addAll(interfaceParsers);
        }
    }

    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) throws Exception {
        ArrayList<ProxyInvocationHandler> invocationHandlerList = new ArrayList<ProxyInvocationHandler>();
        HashSet<String> invocationHandlerRepeatCheck = new HashSet<String>();
        for (InterfaceParser interfaceParser : ALL_INTERFACE_PARSERS) {
            ProxyInvocationHandler proxyInvocationHandler = interfaceParser.parserInterfaceToProxy(target, objectName);
            if (proxyInvocationHandler == null) continue;
            if (!invocationHandlerRepeatCheck.add(proxyInvocationHandler.type())) {
                throw new RuntimeException("there is already an annotation of type " + proxyInvocationHandler.type() + " for class: " + target.getClass().getName());
            }
            invocationHandlerList.add(proxyInvocationHandler);
        }
        Collections.sort(invocationHandlerList, Comparator.comparingInt(ProxyInvocationHandler::order));
        ProxyInvocationHandler first = null;
        ProxyInvocationHandler last = null;
        for (ProxyInvocationHandler proxyInvocationHandler : invocationHandlerList) {
            if (first == null) {
                first = proxyInvocationHandler;
            }
            if (last != null) {
                last.setNextProxyInvocationHandler(proxyInvocationHandler);
            }
            last = proxyInvocationHandler;
        }
        return first;
    }

    @Override
    public IfNeedEnhanceBean parseIfNeedEnhancement(Class<?> beanClass) {
        for (InterfaceParser interfaceParser : ALL_INTERFACE_PARSERS) {
            IfNeedEnhanceBean ifNeedEnhanceBean = interfaceParser.parseIfNeedEnhancement(beanClass);
            if (!ifNeedEnhanceBean.isIfNeed()) continue;
            return ifNeedEnhanceBean;
        }
        return new IfNeedEnhanceBean();
    }

    private static class SingletonHolder {
        private static final DefaultInterfaceParser INSTANCE = new DefaultInterfaceParser();

        private SingletonHolder() {
        }
    }
}

