/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.interceptor.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.integration.tx.api.interceptor.InvocationWrapper;
import org.apache.seata.integration.tx.api.interceptor.NestInterceptorHandlerWrapper;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;

public abstract class AbstractProxyInvocationHandler
implements ProxyInvocationHandler {
    protected int order = Integer.MAX_VALUE;
    protected ProxyInvocationHandler nextInvocationHandlerChain;

    protected abstract Object doInvoke(InvocationWrapper var1) throws Throwable;

    @Override
    public Object invoke(InvocationWrapper invocation) throws Throwable {
        if (CollectionUtils.isNotEmpty(this.getMethodsToProxy()) && !this.getMethodsToProxy().contains(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        if (this.nextInvocationHandlerChain != null) {
            invocation = new NestInterceptorHandlerWrapper(this.nextInvocationHandlerChain, invocation);
        }
        return this.doInvoke(invocation);
    }

    public <T extends Annotation> T getAnnotation(Method method, Class<?> targetClass, Class<T> annotationClass) {
        return (T)((Annotation)Optional.ofNullable(method).map(m -> m.getAnnotation(annotationClass)).orElse(Optional.ofNullable(targetClass).map(t -> t.getAnnotation(annotationClass)).orElse(null)));
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setNextProxyInvocationHandler(ProxyInvocationHandler next) {
        this.nextInvocationHandlerChain = next;
    }
}

