/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.fence.hook;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.seata.common.lock.ResourceLock;
import org.apache.seata.integration.tx.api.fence.hook.TccHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TccHookManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TccHookManager.class);
    private static final ResourceLock LOCK = new ResourceLock();
    private static final List<TccHook> TCC_HOOKS = new CopyOnWriteArrayList<TccHook>();
    private static volatile List<TccHook> CACHED_UNMODIFIABLE_HOOKS = null;

    private TccHookManager() {
    }

    public static List<TccHook> getHooks() {
        if (CACHED_UNMODIFIABLE_HOOKS == null) {
            try (ResourceLock ignored = LOCK.obtain();){
                if (CACHED_UNMODIFIABLE_HOOKS == null) {
                    CACHED_UNMODIFIABLE_HOOKS = Collections.unmodifiableList(TCC_HOOKS);
                }
            }
        }
        return CACHED_UNMODIFIABLE_HOOKS;
    }

    public static void registerHook(TccHook tccHook) {
        if (tccHook == null) {
            throw new NullPointerException("tccHook must not be null");
        }
        TCC_HOOKS.add(tccHook);
        CACHED_UNMODIFIABLE_HOOKS = null;
        LOGGER.info("TccHook registered succeeded! TccHooks size: {}", (Object)TCC_HOOKS.size());
    }

    public static void clear() {
        TCC_HOOKS.clear();
        CACHED_UNMODIFIABLE_HOOKS = null;
        LOGGER.info("All TccHooks have been cleared.");
    }
}

