/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.motan;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.Scope;
import com.weibo.api.motan.core.extension.Spi;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Spi(scope=Scope.SINGLETON)
@Activation(key={"service", "referer"}, sequence=100)
public class MotanTransactionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotanTransactionFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response filter(Caller<?> caller, Request request) {
        String currentXid = RootContext.getXID();
        BranchType branchType = RootContext.getBranchType();
        String requestXid = this.getRpcXid(request);
        String rpcBranchType = this.getBranchType(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("context in RootContext[{},{}], context in RpcContext[{},{}]", new Object[]{currentXid, branchType, requestXid, rpcBranchType});
        }
        boolean bind = false;
        if (currentXid != null) {
            request.getAttachments().put("TX_XID", currentXid);
            request.getAttachments().put("TX_BRANCH_TYPE", branchType.name());
        } else if (requestXid != null) {
            RootContext.bind(requestXid);
            if (StringUtils.equals(BranchType.TCC.name(), rpcBranchType)) {
                RootContext.bindBranchType(BranchType.TCC);
            }
            bind = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind [{}] to RootContext", (Object)requestXid);
            }
        }
        try {
            Response response = caller.call(request);
            return response;
        }
        finally {
            if (bind) {
                BranchType previousBranchType = RootContext.getBranchType();
                String unbindXid = RootContext.unbind();
                if (BranchType.TCC == previousBranchType) {
                    RootContext.unbindBranchType();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
                }
                if (!requestXid.equalsIgnoreCase(unbindXid)) {
                    LOGGER.warn("xid has changed, during RPC from [{}] to [{}]", (Object)requestXid, (Object)unbindXid);
                    if (unbindXid != null) {
                        RootContext.bind(unbindXid);
                        LOGGER.warn("bind [{}}] back to RootContext", (Object)unbindXid);
                        if (BranchType.TCC == previousBranchType) {
                            RootContext.bindBranchType(BranchType.TCC);
                            LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                        }
                    }
                }
            }
        }
    }

    private String getRpcXid(Request request) {
        String rpcXid = (String)request.getAttachments().get("TX_XID");
        if (rpcXid == null) {
            rpcXid = (String)request.getAttachments().get("TX_XID".toLowerCase());
        }
        return rpcXid;
    }

    private String getBranchType(Request request) {
        return (String)request.getAttachments().get("TX_BRANCH_TYPE");
    }
}

