/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.hsf;

import com.taobao.hsf.context.RPCContext;
import com.taobao.hsf.invocation.Invocation;
import com.taobao.hsf.invocation.InvocationHandler;
import com.taobao.hsf.invocation.RPCResult;
import com.taobao.hsf.invocation.filter.ServerFilter;
import com.taobao.hsf.util.concurrent.ListenableFuture;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsfTransactionProviderFilter
implements ServerFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HsfTransactionProviderFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RPCResult> invoke(InvocationHandler nextHandler, Invocation invocation) throws Throwable {
        ListenableFuture listenableFuture;
        block17: {
            Object rpcXid = RPCContext.getServerContext().getAttachment("TX_XID");
            Object rpcBranchType = RPCContext.getServerContext().getAttachment("TX_BRANCH_TYPE");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid in RpcContext[{}], branchType in RpcContext[{}]", rpcXid, rpcBranchType);
            }
            boolean bind = false;
            if (rpcXid != null) {
                RootContext.bind(rpcXid.toString());
                if (StringUtils.equals(BranchType.TCC.name(), rpcBranchType.toString())) {
                    RootContext.bindBranchType(BranchType.TCC);
                }
                bind = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("bind xid [{}] branchType [{}] to RootContext", rpcXid, rpcBranchType);
                }
            }
            try {
                listenableFuture = nextHandler.invoke(invocation);
                if (!bind) break block17;
            }
            catch (Throwable throwable) {
                if (bind) {
                    BranchType previousBranchType = RootContext.getBranchType();
                    String unbindXid = RootContext.unbind();
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.unbindBranchType();
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
                    }
                    if (!rpcXid.toString().equalsIgnoreCase(unbindXid)) {
                        LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType});
                        if (unbindXid != null) {
                            RootContext.bind(unbindXid);
                            LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                            if (BranchType.TCC == previousBranchType) {
                                RootContext.bindBranchType(BranchType.TCC);
                                LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                            }
                        }
                    }
                }
                RPCContext.getServerContext().removeAttachment("TX_XID");
                RPCContext.getServerContext().removeAttachment("TX_BRANCH_TYPE");
                throw throwable;
            }
            BranchType previousBranchType = RootContext.getBranchType();
            String unbindXid = RootContext.unbind();
            if (BranchType.TCC == previousBranchType) {
                RootContext.unbindBranchType();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
            }
            if (!rpcXid.toString().equalsIgnoreCase(unbindXid)) {
                LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType});
                if (unbindXid != null) {
                    RootContext.bind(unbindXid);
                    LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.bindBranchType(BranchType.TCC);
                        LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                    }
                }
            }
        }
        RPCContext.getServerContext().removeAttachment("TX_XID");
        RPCContext.getServerContext().removeAttachment("TX_BRANCH_TYPE");
        return listenableFuture;
    }

    public void onResponse(Invocation invocation, RPCResult rpcResult) {
    }
}

