/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.raft;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.seata.common.exception.AuthenticationFailedException;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.exception.ParseEndpointException;
import org.apache.seata.common.exception.RetryableException;
import org.apache.seata.common.metadata.Metadata;
import org.apache.seata.common.metadata.MetadataResponse;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.HttpClientUtil;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigChangeListener;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.registry.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftRegistryServiceImpl
implements RegistryService<ConfigChangeListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftRegistryServiceImpl.class);
    private static final String REGISTRY_TYPE = "raft";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String PRO_USERNAME_KEY = "username";
    private static final String PRO_PASSWORD_KEY = "password";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String TOKEN_VALID_TIME_MS_KEY = "tokenValidityInMilliseconds";
    private static final String META_DATA_MAX_AGE_MS = "metadataMaxAgeMs";
    private static final long TOKEN_EXPIRE_TIME_IN_MILLISECONDS;
    private static final String USERNAME;
    private static final String PASSWORD;
    public static String jwtToken;
    private static long tokenTimeStamp;
    private static volatile RaftRegistryServiceImpl instance;
    private static final Configuration CONFIG;
    private static final String IP_PORT_SPLIT_CHAR = ":";
    private static final Map<String, List<InetSocketAddress>> INIT_ADDRESSES;
    private static final Metadata METADATA;
    private static final ObjectMapper OBJECT_MAPPER;
    private static volatile String CURRENT_TRANSACTION_SERVICE_GROUP;
    private static volatile String CURRENT_TRANSACTION_CLUSTER_NAME;
    private static volatile ThreadPoolExecutor REFRESH_METADATA_EXECUTOR;
    private static final AtomicBoolean CLOSED;
    private static final Map<String, List<InetSocketAddress>> ALIVE_NODES;
    private static final String PREFERRED_NETWORKS;

    private RaftRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RaftRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<RaftRegistryServiceImpl> clazz = RaftRegistryServiceImpl.class;
        synchronized (RaftRegistryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new RaftRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
    }

    @Override
    public void subscribe(String cluster, ConfigChangeListener listener) throws Exception {
    }

    @Override
    public void unsubscribe(String cluster, ConfigChangeListener listener) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void startQueryMetadata() {
        if (REFRESH_METADATA_EXECUTOR == null) {
            Map<String, List<InetSocketAddress>> map = INIT_ADDRESSES;
            synchronized (map) {
                if (REFRESH_METADATA_EXECUTOR == null) {
                    REFRESH_METADATA_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("refreshMetadata", 1, true));
                    REFRESH_METADATA_EXECUTOR.execute(() -> {
                        long metadataMaxAgeMs = CONFIG.getLong(RaftRegistryServiceImpl.getMetadataMaxAgeMs(), 30000L);
                        long currentTime = System.currentTimeMillis();
                        while (!CLOSED.get()) {
                            try {
                                boolean fetch = System.currentTimeMillis() - currentTime > metadataMaxAgeMs;
                                String clusterName = CURRENT_TRANSACTION_CLUSTER_NAME;
                                if (!fetch) {
                                    fetch = RaftRegistryServiceImpl.watch();
                                }
                                if (!fetch) continue;
                                for (String group : METADATA.groups(clusterName)) {
                                    try {
                                        RaftRegistryServiceImpl.acquireClusterMetaData(clusterName, group);
                                    }
                                    catch (Exception e) {
                                        if (e instanceof RetryableException) {
                                            throw e;
                                        }
                                        LOGGER.error("failed to get the leader address,error: {}", (Object)e.getMessage());
                                    }
                                }
                                currentTime = System.currentTimeMillis();
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug("refresh seata cluster metadata time: {}", (Object)currentTime);
                            }
                            catch (RetryableException e) {
                                LOGGER.error(e.getMessage(), (Throwable)e);
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    });
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        CLOSED.compareAndSet(false, true);
                        REFRESH_METADATA_EXECUTOR.shutdown();
                    }));
                }
            }
        }
    }

    private static String queryHttpAddress(String clusterName, String group) {
        List<Node> nodeList = METADATA.getNodes(clusterName, group);
        List addressList = null;
        Stream stream = null;
        if (CollectionUtils.isNotEmpty(nodeList)) {
            List<InetSocketAddress> inetSocketAddresses = ALIVE_NODES.get(CURRENT_TRANSACTION_SERVICE_GROUP);
            if (CollectionUtils.isEmpty(inetSocketAddresses)) {
                addressList = nodeList.stream().map(RaftRegistryServiceImpl::selectControlEndpointStr).collect(Collectors.toList());
            } else {
                stream = inetSocketAddresses.stream();
            }
        } else {
            stream = INIT_ADDRESSES.get(clusterName).stream();
        }
        if (addressList != null) {
            return (String)addressList.get(ThreadLocalRandom.current().nextInt(addressList.size()));
        }
        HashMap<String, Node> map = new HashMap<String, Node>();
        if (CollectionUtils.isNotEmpty(nodeList)) {
            for (Node node : nodeList) {
                InetSocketAddress inetSocketAddress2 = RaftRegistryServiceImpl.selectTransactionEndpoint(node);
                map.put(inetSocketAddress2.getHostString() + IP_PORT_SPLIT_CHAR + inetSocketAddress2.getPort(), node);
            }
        }
        addressList = stream.map(inetSocketAddress -> {
            String host = NetUtil.toStringHost(inetSocketAddress);
            Node node = (Node)map.get(host + IP_PORT_SPLIT_CHAR + inetSocketAddress.getPort());
            InetSocketAddress controlEndpoint = null;
            if (node != null) {
                controlEndpoint = RaftRegistryServiceImpl.selectControlEndpoint(node);
            }
            return host + IP_PORT_SPLIT_CHAR + (controlEndpoint != null ? controlEndpoint.getPort() : inetSocketAddress.getPort());
        }).collect(Collectors.toList());
        return (String)addressList.get(ThreadLocalRandom.current().nextInt(addressList.size()));
    }

    private static String getRaftAddrFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_SERVER_ADDR_KEY);
    }

    private static String getRaftUserNameKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_USERNAME_KEY);
    }

    private static String getRaftPassWordKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_PASSWORD_KEY);
    }

    private static String getPreferredNetworks() {
        return String.join((CharSequence)".", "registry", "preferredNetworks");
    }

    private static String getTokenExpireTimeInMillisecondsKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, TOKEN_VALID_TIME_MS_KEY);
    }

    private static boolean isTokenExpired() {
        if (tokenTimeStamp == -1L) {
            return true;
        }
        long tokenExpiredTime = tokenTimeStamp + TOKEN_EXPIRE_TIME_IN_MILLISECONDS;
        return System.currentTimeMillis() >= tokenExpiredTime;
    }

    private static String selectControlEndpointStr(Node node) {
        InetSocketAddress control = RaftRegistryServiceImpl.selectControlEndpoint(node);
        return NetUtil.toStringAddress(control);
    }

    private static String selectTransactionEndpointStr(Node node) {
        InetSocketAddress transaction = RaftRegistryServiceImpl.selectTransactionEndpoint(node);
        return NetUtil.toStringAddress(transaction);
    }

    private static InetSocketAddress selectControlEndpoint(Node node) {
        return RaftRegistryServiceImpl.selectEndpoint("control", node);
    }

    private static InetSocketAddress selectTransactionEndpoint(Node node) {
        return RaftRegistryServiceImpl.selectEndpoint("transaction", node);
    }

    private static InetSocketAddress selectEndpoint(String type, Node node) {
        if (StringUtils.isBlank(PREFERRED_NETWORKS)) {
            switch (type) {
                case "control": {
                    return new InetSocketAddress(node.getControl().getHost(), node.getControl().getPort());
                }
                case "transaction": {
                    return new InetSocketAddress(node.getTransaction().getHost(), node.getTransaction().getPort());
                }
            }
            throw new NotSupportYetException("SelectEndpoint is not support type: " + type);
        }
        Node.ExternalEndpoint externalEndpoint = RaftRegistryServiceImpl.selectExternalEndpoint(node, PREFERRED_NETWORKS.split(";"));
        switch (type) {
            case "control": {
                return new InetSocketAddress(externalEndpoint.getHost(), externalEndpoint.getControlPort());
            }
            case "transaction": {
                return new InetSocketAddress(externalEndpoint.getHost(), externalEndpoint.getTransactionPort());
            }
        }
        throw new NotSupportYetException("SelectEndpoint is not support type: " + type);
    }

    private static Node.ExternalEndpoint selectExternalEndpoint(Node node, String[] preferredNetworks) {
        Map<String, Object> metadata = node.getMetadata();
        if (CollectionUtils.isEmpty(metadata)) {
            throw new ParseEndpointException("Node metadata is empty.");
        }
        Object external = metadata.get("external");
        if (external instanceof List) {
            List externalEndpoints = (List)external;
            if (CollectionUtils.isEmpty(externalEndpoints)) {
                throw new ParseEndpointException("ExternalEndpoints should not be empty.");
            }
            for (LinkedHashMap externalEndpoint : externalEndpoints) {
                String ip = Optional.ofNullable(externalEndpoint.get("host")).map(Object::toString).orElse("");
                if (!RaftRegistryServiceImpl.isPreferredNetwork(ip, Arrays.asList(preferredNetworks))) continue;
                return RaftRegistryServiceImpl.createExternalEndpoint(externalEndpoint, ip);
            }
        }
        throw new ParseEndpointException("No ExternalEndpoints value matches.");
    }

    private static boolean isPreferredNetwork(String ip, List<String> preferredNetworks) {
        return preferredNetworks.stream().anyMatch(regex -> StringUtils.isNotBlank(regex) && (ip.matches((String)regex) || ip.startsWith((String)regex)));
    }

    private static Node.ExternalEndpoint createExternalEndpoint(LinkedHashMap<String, Object> externalEndpoint, String ip) {
        int controlPort = Integer.parseInt(externalEndpoint.get("controlPort").toString());
        int transactionPort = Integer.parseInt(externalEndpoint.get("transactionPort").toString());
        return new Node.ExternalEndpoint(ip, controlPort, transactionPort);
    }

    @Override
    public void close() {
        CLOSED.compareAndSet(false, true);
    }

    @Override
    public List<InetSocketAddress> aliveLookup(String transactionServiceGroup) {
        String clusterName;
        Node leader;
        if (METADATA.isRaftMode() && (leader = METADATA.getLeader(clusterName = this.getServiceGroup(transactionServiceGroup))) != null) {
            return Collections.singletonList(RaftRegistryServiceImpl.selectTransactionEndpoint(leader));
        }
        return RegistryService.super.aliveLookup(transactionServiceGroup);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean watch() throws RetryableException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        HashMap<String, String> param = new HashMap<String, String>();
        String clusterName = CURRENT_TRANSACTION_CLUSTER_NAME;
        Map<String, Long> groupTerms = METADATA.getClusterTerm(clusterName);
        groupTerms.forEach((k, v) -> param.put((String)k, String.valueOf(v)));
        Iterator<String> iterator = groupTerms.keySet().iterator();
        if (!iterator.hasNext()) return false;
        String group = iterator.next();
        String tcAddress = RaftRegistryServiceImpl.queryHttpAddress(clusterName, group);
        if (RaftRegistryServiceImpl.isTokenExpired()) {
            RaftRegistryServiceImpl.refreshToken(tcAddress);
        }
        if (StringUtils.isNotBlank(jwtToken)) {
            header.put(AUTHORIZATION_HEADER, jwtToken);
        }
        try (CloseableHttpResponse response = HttpClientUtil.doPost("http://" + tcAddress + "/metadata/v1/watch", param, header, 30000);){
            if (response == null) return false;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 401) {
                if (!StringUtils.isNotBlank(USERNAME)) throw new AuthenticationFailedException("Authentication failed! you should configure the correct username and password.");
                if (!StringUtils.isNotBlank(PASSWORD)) throw new AuthenticationFailedException("Authentication failed! you should configure the correct username and password.");
                throw new RetryableException("Authentication failed!");
            }
            boolean bl = statusLine != null && statusLine.getStatusCode() == 200;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("watch cluster node: {}, fail: {}", (Object)tcAddress, (Object)e.getMessage());
            throw new RetryableException(e.getMessage(), e);
        }
    }

    @Override
    public List<InetSocketAddress> refreshAliveLookup(String transactionServiceGroup, List<InetSocketAddress> aliveAddress) {
        if (METADATA.isRaftMode()) {
            Node leader = METADATA.getLeader(this.getServiceGroup(transactionServiceGroup));
            InetSocketAddress leaderAddress = RaftRegistryServiceImpl.selectTransactionEndpoint(leader);
            return ALIVE_NODES.put(transactionServiceGroup, aliveAddress.isEmpty() ? aliveAddress : aliveAddress.parallelStream().filter(inetSocketAddress -> inetSocketAddress.getPort() != leaderAddress.getPort() || !inetSocketAddress.getAddress().getHostAddress().equals(leaderAddress.getAddress().getHostAddress())).collect(Collectors.toList()));
        }
        return RegistryService.super.refreshAliveLookup(transactionServiceGroup, aliveAddress);
    }

    private static void acquireClusterMetaDataByClusterName(String clusterName) {
        try {
            RaftRegistryServiceImpl.acquireClusterMetaData(clusterName, "");
        }
        catch (RetryableException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static void acquireClusterMetaData(String clusterName, String group) throws RetryableException {
        String tcAddress = RaftRegistryServiceImpl.queryHttpAddress(clusterName, group);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        if (RaftRegistryServiceImpl.isTokenExpired()) {
            RaftRegistryServiceImpl.refreshToken(tcAddress);
        }
        if (StringUtils.isNotBlank(jwtToken)) {
            header.put(AUTHORIZATION_HEADER, jwtToken);
        }
        if (StringUtils.isNotBlank(tcAddress)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("group", group);
            String response = null;
            try (CloseableHttpResponse httpResponse = HttpClientUtil.doGet("http://" + tcAddress + "/metadata/v1/cluster", param, header, 1000);){
                if (httpResponse != null) {
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    } else {
                        if (statusCode == 401) {
                            if (StringUtils.isNotBlank(USERNAME) && StringUtils.isNotBlank(PASSWORD)) {
                                RaftRegistryServiceImpl.refreshToken(tcAddress);
                                throw new RetryableException("Token refreshed, retrying request.");
                            }
                            throw new AuthenticationFailedException("Authentication failed! you should configure the correct username and password.");
                        }
                        throw new AuthenticationFailedException("Authentication failed! you should configure the correct username and password.");
                    }
                }
                if (StringUtils.isNotBlank(response)) {
                    try {
                        MetadataResponse metadataResponse = (MetadataResponse)OBJECT_MAPPER.readValue(response, MetadataResponse.class);
                        METADATA.refreshMetadata(clusterName, metadataResponse);
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                throw new RetryableException(e.getMessage(), e);
            }
        }
    }

    private static void refreshToken(String tcAddress) throws RetryableException {
        block17: {
            if (StringUtils.isBlank(USERNAME) || StringUtils.isBlank(PASSWORD)) {
                return;
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put(PRO_USERNAME_KEY, USERNAME);
            param.put(PRO_PASSWORD_KEY, PASSWORD);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            String response = null;
            try (CloseableHttpResponse httpResponse = HttpClientUtil.doPost("http://" + tcAddress + "/api/v1/auth/login", param, header, 1000);){
                if (httpResponse == null) break block17;
                if (httpResponse.getStatusLine().getStatusCode() == 200) {
                    response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    JsonNode jsonNode = OBJECT_MAPPER.readTree(response);
                    String codeStatus = jsonNode.get("code").asText();
                    if (!StringUtils.equals(codeStatus, "200")) {
                        throw new AuthenticationFailedException("Authentication failed! you should configure the correct username and password.");
                    }
                    jwtToken = jsonNode.get("data").asText();
                    tokenTimeStamp = System.currentTimeMillis();
                    break block17;
                }
                throw new AuthenticationFailedException("Authentication failed! you should configure the correct username and password.");
            }
            catch (IOException e) {
                throw new RetryableException(e.getMessage(), e);
            }
        }
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        List<Node> nodes;
        String raftClusterAddress;
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            return null;
        }
        CURRENT_TRANSACTION_SERVICE_GROUP = key;
        CURRENT_TRANSACTION_CLUSTER_NAME = clusterName;
        if (!METADATA.containsGroup(clusterName) && StringUtils.isNotBlank(raftClusterAddress = CONFIG.getConfig(RaftRegistryServiceImpl.getRaftAddrFileKey()))) {
            String[] addresses;
            ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
            for (String address : addresses = raftClusterAddress.split(",")) {
                String[] endpoint = address.split(IP_PORT_SPLIT_CHAR);
                String host = endpoint[0];
                int port = Integer.parseInt(endpoint[1]);
                list.add(new InetSocketAddress(host, port));
            }
            if (CollectionUtils.isEmpty(list)) {
                return null;
            }
            INIT_ADDRESSES.put(clusterName, list);
            try {
                RaftRegistryServiceImpl.refreshToken(RaftRegistryServiceImpl.queryHttpAddress(clusterName, key));
            }
            catch (Exception e) {
                throw new RuntimeException("Init fetch token failed!", e);
            }
            RaftRegistryServiceImpl.acquireClusterMetaDataByClusterName(clusterName);
            RaftRegistryServiceImpl.startQueryMetadata();
        }
        if (CollectionUtils.isNotEmpty(nodes = METADATA.getNodes(clusterName))) {
            return nodes.parallelStream().map(RaftRegistryServiceImpl::selectTransactionEndpoint).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static String getMetadataMaxAgeMs() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, META_DATA_MAX_AGE_MS);
    }

    static {
        tokenTimeStamp = -1L;
        CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        INIT_ADDRESSES = new HashMap<String, List<InetSocketAddress>>();
        METADATA = new Metadata();
        OBJECT_MAPPER = new ObjectMapper();
        CLOSED = new AtomicBoolean(false);
        ALIVE_NODES = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        TOKEN_EXPIRE_TIME_IN_MILLISECONDS = CONFIG.getLong(RaftRegistryServiceImpl.getTokenExpireTimeInMillisecondsKey(), 1740000L);
        USERNAME = CONFIG.getConfig(RaftRegistryServiceImpl.getRaftUserNameKey());
        PASSWORD = CONFIG.getConfig(RaftRegistryServiceImpl.getRaftPassWordKey());
        PREFERRED_NETWORKS = CONFIG.getConfig(RaftRegistryServiceImpl.getPreferredNetworks());
    }
}

