/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.loadbalance;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.discovery.loadbalance.LoadBalance;

@LoadLevel(name="RoundRobinLoadBalance")
public class RoundRobinLoadBalance
implements LoadBalance {
    private final AtomicInteger sequence = new AtomicInteger();

    @Override
    public <T> T select(List<T> invokers, String xid) {
        int length = invokers.size();
        return invokers.get(this.getPositiveSequence() % length);
    }

    private int getPositiveSequence() {
        int next;
        int current;
        while (!this.sequence.compareAndSet(current, next = (current = this.sequence.get()) >= Integer.MAX_VALUE ? 0 : current + 1)) {
        }
        return current;
    }
}

