/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.seata.core.protocol.detector.Http2Detector;
import org.apache.seata.core.protocol.detector.ProtocolDetector;
import org.apache.seata.core.protocol.detector.SeataDetector;
import org.apache.seata.core.rpc.netty.NettyServerBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDetectHandler
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolDetectHandler.class);
    private NettyServerBootstrap nettyServerBootstrap;
    private ProtocolDetector[] supportedProtocolDetectors;

    public ProtocolDetectHandler(NettyServerBootstrap nettyServerBootstrap) {
        this.nettyServerBootstrap = nettyServerBootstrap;
        this.supportedProtocolDetectors = new ProtocolDetector[]{new Http2Detector(nettyServerBootstrap.getChannelHandlers()), new SeataDetector(nettyServerBootstrap.getChannelHandlers())};
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        for (ProtocolDetector protocolDetector : this.supportedProtocolDetectors) {
            if (protocolDetector.detect(in)) {
                ChannelHandler[] protocolHandlers = protocolDetector.getHandlers();
                ctx.pipeline().addLast(protocolHandlers);
                ctx.pipeline().remove((ChannelHandler)this);
                in.resetReaderIndex();
                return;
            }
            in.resetReaderIndex();
        }
        byte[] preface = new byte[in.readableBytes()];
        in.readBytes(preface);
        LOGGER.error("Can not recognize protocol from remote {}, preface = {}", (Object)ctx.channel().remoteAddress(), (Object)preface);
        in.clear();
        ctx.close();
    }
}

